/********************************************/
/* Copyright Industrial Software Technology */
/********************************************/

package iceTea.util.jar;

import iceTea.io.File;
import iceTea.lang.support.I2jConstants;
import iceTea.lang.support.IceteaArraySupport;
import iceTea.lang.support.IceteaStringSupport;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;


public class JarFile{

    public static final int OPEN_DELETE = 4,
                            OPEN_READ   = 1;
    
    private java.util.jar.JarFile jarFile;
    
    public JarFile(File file){
        try{
            jarFile = new java.util.jar.JarFile(file.getFile());
        }
        catch(IOException e){
            
            throw new RuntimeException(e.getMessage());
            
        }
    }
    
    public JarFile(File file,boolean verify){
        try{
            jarFile = new java.util.jar.JarFile(file.getFile(),verify);
        }
        catch(IOException e){
            throw new RuntimeException(e.getMessage());
        }
    }
    
    public JarFile(File file,boolean verify,int mode){
        try{
            jarFile = new java.util.jar.JarFile(file.getFile(),verify,mode);
        }
        catch(IOException e){
            throw new RuntimeException(e.getMessage());
        }
    }
    
    public JarFile(iceTea.lang.String name){
        try{
            jarFile = new java.util.jar.JarFile(name.toString());
        }
        catch(IOException e){
            throw new RuntimeException(e.getMessage());
        }
    }
    
    public JarFile(iceTea.lang.String name,boolean verify){
        try{
            jarFile = new java.util.jar.JarFile(name.toString(),verify);
        }
        catch(IOException e){
            throw new RuntimeException(e.getMessage());
        }
    }
    
    public JarEntry[] entries(){
        Enumeration enumjar = jarFile.entries();
        
        JarEntry[] array = new JarEntry[jarFile.size()];
        
        int i=0;
        while(enumjar.hasMoreElements())
            array[i++] = new JarEntry((java.util.jar.JarEntry)enumjar.nextElement());
        
        return array;
    }
    
    
    public JarEntry getJarEntry(iceTea.lang.String name){
        try{
            return new JarEntry(jarFile.getJarEntry(name.toString()));
        }
        catch(NullPointerException e){
            return null;
        }
    }
    
    public void close(){
        try{
            jarFile.close();
        }
        catch(IOException e){}
        catch(NullPointerException e){}
    }
    
    //return null on error
   // public byte[] getData(JarEntry entry){
    public int getData(JarEntry entry){
        try{
            InputStream istream = jarFile.getInputStream(entry.getEntry());
            int available = istream.available();
            byte[] data = new byte[available];
            int ptr = 0;
            while(ptr < available)
            {
                ptr += istream.read(data, ptr, available-ptr);                
            }
            return IceteaArraySupport.fromJavaToIceteaArray(data);
        }
        catch(IOException e){}
        catch(NullPointerException e){}
        return I2jConstants.NULL;
    }
    
    public iceTea.lang.String getName(){
        return IceteaStringSupport.fromJavaLangString(jarFile.getName());
    }
    
    public int size(){
        return jarFile.size();
    }
    
}
