package iceTea.structs;

import java.lang.StringBuilder;
import icetea.os.Thread;
import iceTea.lang.support.IceteaRuntimeSupport;
import iceTea.lang.Struct;
import iceTea.lang.Memories;

public class CharRefBigEndian extends Struct{

	public static final int OFFSET_value = 0;/*value*/
	public static final int STRUCT_sizeOf = 2;
	
	public CharRefBigEndian(int a) {
		super(a);
	}
	
	public static char toBigEndian(char value) {
		int i2j_allocaPtr = IceteaRuntimeSupport.currentAllocaPtr();
		int big = Thread.currentThread().allocateArrayNoInit('\u0002', 1)/*new byte['\u0002'];*/;/*iceTea.structs.CharRefBigEndian big = new iceTea.structs.CharRefBigEndian(iceTea.structs.CharRefBigEndian.ram(new byte['\u0002']).startAddressInt());*/
		Memories.setChar(big + 0/*CharRefBigEndian.value*/, value);
		return (char)IceteaRuntimeSupport.i2j_return(Memories.getChar(big + 0/*CharRef.value*/), i2j_allocaPtr);
	}
	public static char toPlatformEndian(char bigEndianValue) {
		int i2j_allocaPtr = IceteaRuntimeSupport.currentAllocaPtr();
		int big = Thread.currentThread().allocateArrayNoInit('\u0002', 1)/*new byte['\u0002'];*/;/*iceTea.structs.CharRef big = new iceTea.structs.CharRef(iceTea.structs.CharRefBigEndian.ram(new byte['\u0002']).startAddressInt());*/
		Memories.setChar(big + 0/*CharRef.value*/, bigEndianValue);
		return (char)IceteaRuntimeSupport.i2j_return(Memories.getChar(big + 0/*CharRefBigEndian.value*/), i2j_allocaPtr);
	}
	public void i2j_toString(StringBuilder sb) {
		sb.append("value=");
		sb.append(Memories.getChar(i2j_startAddress + 0));
	}
	
}