package iceTea.lang.support;

import iceTea.lang.Memories;

import java.util.ArrayList;

public class TraceHelper implements I2jConstants{
	
	// all used this static should be surround by :
	//		if  (I2JCheckConstants.ACTIVATE_CHECK)
	// -> ONLY for debug jar ...
	
	// TRACE ALL HEAP ALLOCATION
	public static  boolean MEMORIES_HEAP_ALLOCATION = false; // true for printing trace when allocate or free data on heap
	//FOR TRACE ALL STACK ALLOCATION
	public static  boolean MEMORIES_STACK_ALLOCATION =false; // true for printing trace when allocate or free data on thread stack

	// TRACE LEVEL
	public static  int TRACE_ALLOCATION=1;	// level of trace for allocation : 0 = no trace, 1=simple trace, 2 = printStackTrace
	public static  int TRACE_FREE= 1;		// level of trace for free : 0 = no trace, 1=simple trace, 2 = printStackTrace
	
	//FOR ADD A MODIFICATION BREAKPOINT ON AN ADDRESS OF MEMORIES
	public static  int BREAKPOINT_ON_MEMORIES =0; // 0 no  breakpoint, 1 write, 2 read
	public static int AddressToCheck= 8191013;	   // address in Memories to check by BREAKPOINT_ON_MEMORIES option

	public static long time;
	
	private static ArrayList AllocIndex;		  // access synchronized...
	static
    {
		if (I2JCheckConstants.ACTIVATE_CHECK)
			AllocIndex = new ArrayList();
	}
	
	//--------- mesurate time
	public static void initTime() {
		time = System.currentTimeMillis();
	}
	
	public static void printTime( String msg) {
		long l = System.currentTimeMillis();
		System.out.println(msg + "->"+ (l -time));
		time = l;
	}
	
	//----------- trace/debug
	public static void traceNoFreed() {
		MEMORIES_HEAP_ALLOCATION= true;
		TRACE_ALLOCATION =1;
		TRACE_FREE = 1;
	}
	
	public static void traceAllocationOfNoFreed() {
		MEMORIES_HEAP_ALLOCATION= true;
		TRACE_ALLOCATION =2;
		TRACE_FREE = 1;
	}
	
	public static void noTrace() {
		MEMORIES_HEAP_ALLOCATION= false;
		MEMORIES_STACK_ALLOCATION=false;
	}
	
	public static synchronized void addStackTrace(StringBuffer sb) {
		StackTraceElement[] ex = new java.lang.Exception().fillInStackTrace().getStackTrace();
		for (int i = 0; i < ex.length; i++) {
			sb.append("\n\t").append(ex[i].toString());				
		}
	}

	//only when I2JCheckConstants.ACTIVATE_CHECK=true
	public static void traceFree( int addr) {
		java.lang.StringBuffer sb =new java.lang.StringBuffer();

		sb.append("\nFree in: @").append(addr).append(" nbBytes: ").append( Memories.getInt(addr -INT_SIZE));

		boolean exist = removeIndex( addr);
		if( ! exist)
			sb.append("\nWARNING : not allocated");
			
		if ( TraceHelper.TRACE_FREE >1) {
			addStackTrace( sb);				
		}
		java.lang.System.err.print(sb.toString());	
	}
	
	//only when I2JCheckConstants.ACTIVATE_CHECK=true
	private static synchronized boolean removeIndex( int at){
		return AllocIndex.remove(new Integer( at));
	}
	
	//only when I2JCheckConstants.ACTIVATE_CHECK=true
	private static synchronized boolean addIndex( int at){
		
		if ( AllocIndex.contains(new Integer( at))) {
			return false;
		}
		else {
			AllocIndex.add(new Integer(at));
			return true;
		}
	}
	
	//only when I2JCheckConstants.ACTIVATE_CHECK=true
	public static void traceAllocation( int at,  int nbElement, int elementSize) {
		java.lang.StringBuffer sb =new java.lang.StringBuffer();
				
		sb.append("\nAt: @").append( at);
		sb.append("\tAllocate Array: ").append(nbElement).append(" elements of size:").append(elementSize);
		
		
		if ( ! addIndex (at)) {
			sb.append("\nWARNING: ").append( at).append(" not free");
		}
		
		
		boolean b= false;
//		int[] adr = new int[] {13324656,13324616,13655900,14221900,13918480};
//		for (int i = 0; i < adr.length; i++) {
//			if ( at == adr[i]) {
//				b =true;
//			}
//		}
	     
		if ( b || TraceHelper.TRACE_ALLOCATION>1) {
			addStackTrace( sb);				
		}
		java.lang.System.err.print(sb.toString());
	}
	
	////only when I2JCheckConstants.ACTIVATE_CHECK=true
	public static synchronized void traceHeapEndAllocation( ) {
		//send only one time at the end of main()
		System.out.println("TraceHelper.traceHeapEndAllocation()");
		//internString are never disposed ...
		int size = AllocIndex.size();
		if ( size > 0){		
			java.lang.StringBuffer sb =new java.lang.StringBuffer();	
			sb.append("\nNot desallocated addresses: ");
			
			for (int i = 0; i < AllocIndex.size(); i++) {
				int addr = ((Integer)AllocIndex.get( i)).intValue();
				sb.append("\n\t@").append( addr);			
			}
			
			java.lang.System.err.println( sb.toString());
		}
		else 
			java.lang.System.err.println("\nMemories is clean");
	}
	
	   /* -----------------------------
     * debug methods for access/modification trace in memories
     * See TraceHelper static to activate bp
     */
    public static void checkAccessTo( int offset, int elementSize) {
    	int address = TraceHelper.AddressToCheck;
    	if ( address >= offset &&  address < offset + elementSize) {
    		java.lang.StringBuffer sb = new  java.lang.StringBuffer();
    		sb.append( "Modification of Memories[");
    		sb.append( address);
    		sb.append( ']');
    		TraceHelper.addStackTrace( sb);
    		java.lang.System.out.println( sb.toString());
    	}
    		
    }

}
