/*
 * Java
 *
 * Copyright 2008-2014 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package iceTea.lang.support;

import iceTea.lang.Memories;
import iceTea.lang.String;
import iceTea.lang.StringBuilder;

import java.util.Enumeration;
import java.util.Hashtable;

/**
 * Perform a 1 to 1 character conversion between Java Strings & IceTea strings.
 * IceTea strings are byte oriented strings, so they can support at most extended ASCII charset.
 */
public class IceteaStringSupport implements I2jConstants {
	// A unique iceTea.lang.String object is associated to each IceTea string literal
	// must handle correctly the == semantic
	/* package */static Hashtable internStrings;

	static {
		internStrings = new Hashtable();
	}

	public static boolean isNotIntern(iceTea.lang.String str) {
		return !internStrings.contains(str);
	}

	public static iceTea.lang.String internString(java.lang.String str) {
		java.lang.Object o;
		if ((o = internStrings.get(str)) != null)
			return (iceTea.lang.String) o;

		iceTea.lang.String uniqueStr = fromJavaLangString(str);
		internStrings.put(str, uniqueStr);
		return uniqueStr;
	}

	public static String setAssignmentPlus(iceTea.lang.String str, boolean b) {
		return new iceTea.lang.StringBuilder(str).append(b).i2j_toString();
	}

	public static String setAssignmentPlus(iceTea.lang.String str, byte b) {
		return new iceTea.lang.StringBuilder(str).append(b).i2j_toString();
	}

	public static String setAssignmentPlus(iceTea.lang.String str, short s) {
		return new StringBuilder(str).append(s).i2j_toString();
	}

	public static String setAssignmentPlus(iceTea.lang.String str, char c) {
		return new StringBuilder(str).append(c).i2j_toString();
	}

	public static String setAssignmentPlus(iceTea.lang.String str, int i) {
		return new StringBuilder(str).append(i).i2j_toString();
	}

	public static String setAssignmentPlus(iceTea.lang.String str, float i) {
		return new StringBuilder(str).append(iceTea.lang.Float.toString(i)).i2j_toString();
	}

	public static String setAssignmentPlus(iceTea.lang.String str, long l) {
		return new StringBuilder(str).append(l).i2j_toString();
	}

	public static String setAssignmentPlus(iceTea.lang.String str, double d) {
		return new StringBuilder(str).append(iceTea.lang.Double.toString(d)).i2j_toString();
	}

	public static String setAssignmentPlus(iceTea.lang.String str, iceTea.lang.String str2) {
		str = str.concat(str2);
		return str;
	}

	public static String setAssignmentPlus(iceTea.lang.String[] tab, int index, iceTea.lang.String str2) {
		iceTea.lang.String str = tab[index].concat(str2);
		tab[index] = str;
		return str;
	}

	/**
	 * Create an iceTea.lang.String from a java.lang.String
	 *
	 * @param str
	 * @return
	 */
	public static String fromJavaLangString(java.lang.String str) {
		char[] chars = str.toCharArray();
		int size = chars.length;
				
		int header = IceteaRuntimeSupport.allocateArrayNoInit(size + 1, BYTE_SIZE); // +1 for the reference on String
		// 1:1 conversion (see class comment)
		for(int i=size; --i>=0;){
			Memories.byteMemory[header+i] = (byte)chars[i];
		}
		Memories.byteMemory[header + size] = (byte) 0;
		return new iceTea.lang.String(header, new byte[0], str.length(), true); // shared array
		// NOTE : do not free header because the return String points on it
	}

	/**
	 * Create an iceTea.lang.String[] from a java.lang.String[]
	 *
	 * @param str
	 * @return
	 */
	public static iceTea.lang.String[] fromJavaLangString(java.lang.String[] tab) {
		if (tab == null)
			return null;

		iceTea.lang.String[] newTab = new iceTea.lang.String[tab.length];
		for (int i = 0; i < tab.length; i++) {
			if (tab[i] == null)
				continue;
			newTab[i] = IceteaStringSupport.fromJavaLangString(tab[i]);
		}
		return newTab;
	}

	/**
	 * Debug Support for String
	 *
	 * @param str
	 * @return
	 */
	public static java.lang.String toString(iceTea.lang.String str) {
		// IceteaRuntimeSupport.precondCheck( str.checkValidity());
		return fromIceTeaByteArrayToJavaString(str.chars, str.length);
	}
	
	public static java.lang.String fromIceTeaByteArrayToJavaString(int addr, int size) {
		char[] chars = new char[size];
		for(int i=chars.length; --i>=0;){
			chars[i] = (char)(Memories.byteMemory[addr + i]&0xFF);
		}		
		return new java.lang.String(chars);
	}

	/**
	 * Debug Support for String : BE CARFUL delete the argument string
	 *
	 * @param str
	 * @return
	 */
	public static java.lang.String toStringAndFree(iceTea.lang.String str) {
		java.lang.String javaStr = toString(str);
		str.dispose();
		return javaStr;
	}

	public static void clearInternString() {
		// free all internString
		Enumeration str = internStrings.keys();
		while (str.hasMoreElements()) {
			java.lang.String javaStr = ((java.lang.String) str.nextElement());
			iceTea.lang.String iceteaStr = ((iceTea.lang.String) internStrings.get(javaStr));
			if (iceteaStr.chars != 0)
				iceteaStr.dispose();
		}
		IceteaStringSupport.internStrings = null;

	}

	public static byte[] toJavaBytes(String str) {
		return IceteaArraySupport.fromIceTeaToJavaArray(str.chars, str.length);
	}

	/**
	 * Debug Support for String
	 *
	 * @param str
	 * @return
	 */
	public static java.lang.String toStringFromBytes(int bytes) {
		return IceteaArraySupport.toString(bytes);
	}

	/**
	 * Debug Support for String
	 *
	 * @param str
	 * @return
	 */
	public static java.lang.String toStringFromChars(int chars) {
		int size = IceteaArraySupport.length(chars);
		java.lang.StringBuffer buf = new java.lang.StringBuffer();
		int offset = chars;
		for (int i = 0; i < size; i++) {
			buf.append(Memories.getChar(offset));
			offset += CHAR_SIZE;
		}
		return buf.toString();
	}

}
