package iceTea.lang.support;

import iceTea.lang.Data;
import iceTea.lang.Memories;
import iceTea.lang.String;
import icetea.os.Thread;

import com.ist.allocator.BestFitAllocator;

public class IceteaRuntimeSupport implements I2jConstants {

	public static Object criticalSection; // doesn't use Monitor here because, Monitor should be generated by the iceTeaToJava ....

	// ----------------initialization of external values / dispose runtimeSupport
	// External values define in Mapping Class (see I2JBestFitAllocatorMapping) can be overridden
	// with value set in System.properties at key propertiesPrefix.<FieldName>
	//
	// propertiesPrefix = "IceteaRuntimeSupport.<prefix>" where prefix depends on running application.
	// For example S3-inJava is generated with option -propertiesPrefix="S3"
	// so S3Launch.main() send setPropertiesPrefix("S3")
	public static java.lang.String propertiesPrefix;

	/**
	 * call at end of execution to free big object ... Dispose all String of tab ...
	 */
	public static void disposeAll(String[] tab) {
		IceteaStringSupport.clearInternString();

		if (tab != null) {
			for (int i = tab.length; --i >= 0;) {
				if (tab[i] == null)
					continue;
				// some string are already deleted by S3OptionManager.dispose()
				if (tab[i].chars != 0)
					tab[i].dispose();
			}
		}

		Data.cleanInitialData();
		IceteaArraySupport.arrayTable = null;

	}

	public static void setPropertiesPrefix(java.lang.String toolPrefix) {
		propertiesPrefix = "IceteaRuntimeSupport." + toolPrefix + ".";
		Memories.initialize();
	}

	/**
	 * Return the System.property value at key "IceteaRuntimeSupport.<toolsName>.<fieldName>" or defaultValue if property not set !
	 *
	 * @param fieldName
	 *            part of property key
	 * @param defaultValue
	 *            : default value if key doesn't exist or value in not an integer
	 * @return the property value parse as int or defaultValue if property at key "IceteaRuntimeSupport.<toolsName>.<fieldName>" doesn't exist
	 */
	public static int getPropertyValueOrDefault(java.lang.String fieldName, int defaultValue) {

		if (propertiesPrefix == null) {
			// compute propertiesPrefix only the first time if nobody has done setPropertiesPrefix()
			// usually propertiesPrefix = "IceteaRuntimeSupport.prefix" where prefix depends on application
			// For example S3 is generated with option -propertiesPrefix="S3" so S3Launch.main() send setPropertiesPrefix("S3")
			propertiesPrefix = "IceteaRuntimeSupport.";
		}

		java.lang.String key = propertiesPrefix + fieldName;
		java.lang.String value = System.getProperty(key);
		if (value == null)
			return defaultValue;

		try {
			return Integer.parseInt(value);
		} catch (NumberFormatException e) {
			return defaultValue;
		}
	}

	// ----------------alloca support
	/**
	 * free all objects of current frame and restore previous frame content
	 *
	 * @param allocaPtr
	 *            : pop allocaStack until allocaPtr
	 */
	public static void freeAllocaObjects(int allocaPtr) {
		Thread.currentThread().freeAllocaObjects(allocaPtr);
	}

	/**
	 * Enter in a new method. Save pointers on previous frame...
	 */
	public static int currentAllocaPtr() {
		return Thread.currentThread().currentAllocaPtr();
	}

	public static boolean i2j_return(boolean returnValue, int allocaPtr) {
		Thread.currentThread().freeAllocaObjects(allocaPtr);
		return returnValue;
	}

	public static float i2j_return(float returnValue, int allocaPtr) {
		Thread.currentThread().freeAllocaObjects(allocaPtr);
		return returnValue;
	}

	public static int i2j_return(int returnValue, int allocaPtr) {
		// NOTE return value should be evaluate after postcondition
		Thread.currentThread().freeAllocaObjects(allocaPtr);
		return returnValue;
	}

	public static byte i2j_return(byte returnValue, int allocaPtr) {
		Thread.currentThread().freeAllocaObjects(allocaPtr);
		return returnValue;
	}

	public static char i2j_return(char returnValue, int allocaPtr) {
		Thread.currentThread().freeAllocaObjects(allocaPtr);
		return returnValue;
	}

	public static short i2j_return(short returnValue, int allocaPtr) {
		Thread.currentThread().freeAllocaObjects(allocaPtr);
		return returnValue;
	}

	public static long i2j_return(long returnValue, int allocaPtr) {
		Thread.currentThread().freeAllocaObjects(allocaPtr);
		return returnValue;
	}

	public static double i2j_return(double returnValue, int allocaPtr) {
		Thread.currentThread().freeAllocaObjects(allocaPtr);
		return returnValue;
	}

	public static Object i2j_return(Object returnValue, int allocaPtr) {
		Thread.currentThread().freeAllocaObjects(allocaPtr);
		return returnValue;
	}

	public static Object[] i2j_return(Object[] returnValue, int allocaPtr) {
		Thread.currentThread().freeAllocaObjects(allocaPtr);
		return returnValue;
	}

	public static java.lang.Object i2j_return(int allocaPtr) {
		Thread.currentThread().freeAllocaObjects(allocaPtr);
		return null;
	}

	// -------------- low/high API
	public final static byte low(char c) {
		return (byte) c;
	}

	public final static byte low(short s) {
		return (byte) s;
	}

	public final static char low(int i) {
		return (char) i;
	}

	public final static byte high(char c) {
		return (byte) (c >>> 8);
	}

	public final static byte high(short s) {
		return (byte) (s >>> 8);
	}

	public final static char high(int i) {
		return (char) (i >>> 16);
	}

	public static int lowhigh(char l, char h) {
		return (h << 16) | l;
	}

	public static int lowhigh(short l, short h) {
		return ((h & 0xFFFF) << 16) | (l & 0xFFFF);
	}

	public static char lowhigh(byte l, byte h) {
		return (char) (((h & 0xFF) << 8) | (l & 0xFF));
	}

	// ------------------ assert and pre/post cond
	public static void assertCheck(boolean b) {
		if (!b)
			throw new AssertionFailedException();
	}

	public static void precondCheck(boolean b) {
		if (!b)
			throw new AssertionFailedException(AssertionFailedException.PRECOND);
	}

	public static void postcondCheck(boolean b) {
		// NOTE return value should be evaluate after postcondition
		if (!b)
			throw new AssertionFailedException(AssertionFailedException.POSTCOND);
	}

	public static float postcondCheck(float returnValue, boolean b) {
		// NOTE return value should be evaluate after postcondition
		if (!b)
			throw new AssertionFailedException(AssertionFailedException.POSTCOND);
		return returnValue;
	}

	public static int postcondCheck(int returnValue, boolean b) {
		// NOTE return value should be evaluate after postcondition
		if (!b)
			throw new AssertionFailedException(AssertionFailedException.POSTCOND);
		return returnValue;
	}

	public static byte postcondCheck(byte returnValue, boolean b) {
		// NOTE return value should be evaluate after postcondition
		if (!b)
			throw new AssertionFailedException(AssertionFailedException.POSTCOND);
		return returnValue;
	}

	public static char postcondCheck(char returnValue, boolean b) {
		// NOTE return value should be evaluate after postcondition
		if (!b)
			throw new AssertionFailedException(AssertionFailedException.POSTCOND);
		return returnValue;
	}

	public static short postcondCheck(short returnValue, boolean b) {
		// NOTE return value should be evaluate after postcondition
		if (!b)
			throw new AssertionFailedException(AssertionFailedException.POSTCOND);
		return returnValue;
	}

	public static long postcondCheck(long returnValue, boolean b) {
		// NOTE return value should be evaluate after postcondition
		if (!b)
			throw new AssertionFailedException(AssertionFailedException.POSTCOND);
		return returnValue;
	}

	public static double postcondCheck(double returnValue, boolean b) {
		// NOTE return value should be evaluate after postcondition
		if (!b)
			throw new AssertionFailedException(AssertionFailedException.POSTCOND);
		return returnValue;
	}

	public static Object postcondCheck(Object returnValue, boolean b) {
		// NOTE return value should be evaluate after postcondition
		if (!b)
			throw new AssertionFailedException(AssertionFailedException.POSTCOND);
		return returnValue;
	}

	public static void postcondCheckWithFreeAlloca(boolean b, int allocaPtr) {
		// NOTE return value should be evaluate after postcondition
		if (!b)
			throw new AssertionFailedException(AssertionFailedException.POSTCOND);
		Thread.currentThread().freeAllocaObjects(allocaPtr);
	}

	public static boolean postcondCheckWithFreeAlloca(boolean returnValue, boolean b, int allocaPtr) {
		// NOTE return value should be evaluate after postcondition
		if (!b)
			throw new AssertionFailedException(AssertionFailedException.POSTCOND);
		return i2j_return(returnValue, allocaPtr);
	}

	public static float postcondCheckWithFreeAlloca(float returnValue, boolean b, int allocaPtr) {
		// NOTE return value should be evaluate after postcondition
		if (!b)
			throw new AssertionFailedException(AssertionFailedException.POSTCOND);
		return i2j_return(returnValue, allocaPtr);
	}

	public static int postcondCheckWithFreeAlloca(int returnValue, boolean b, int allocaPtr) {
		// NOTE return value should be evaluate after postcondition
		if (!b)
			throw new AssertionFailedException(AssertionFailedException.POSTCOND);
		return i2j_return(returnValue, allocaPtr);
	}

	public static byte postcondCheckWithFreeAlloca(byte returnValue, boolean b, int allocaPtr) {
		// NOTE return value should be evaluate after postcondition
		if (!b)
			throw new AssertionFailedException(AssertionFailedException.POSTCOND);
		return i2j_return(returnValue, allocaPtr);
	}

	public static char postcondCheckWithFreeAlloca(char returnValue, boolean b, int allocaPtr) {
		// NOTE return value should be evaluate after postcondition
		if (!b)
			throw new AssertionFailedException(AssertionFailedException.POSTCOND);
		return i2j_return(returnValue, allocaPtr);
	}

	public static short postcondCheckWithFreeAlloca(short returnValue, boolean b, int allocaPtr) {
		// NOTE return value should be evaluate after postcondition
		if (!b)
			throw new AssertionFailedException(AssertionFailedException.POSTCOND);
		return i2j_return(returnValue, allocaPtr);
	}

	public static long postcondCheckWithFreeAlloca(long returnValue, boolean b, int allocaPtr) {
		if (!b)
			throw new AssertionFailedException(AssertionFailedException.POSTCOND);
		return i2j_return(returnValue, allocaPtr);
	}

	public static double postcondCheckWithFreeAlloca(double returnValue, boolean b, int allocaPtr) {
		if (!b)
			throw new AssertionFailedException(AssertionFailedException.POSTCOND);
		return i2j_return(returnValue, allocaPtr);
	}

	public static Object postcondCheckWithFreeAlloca(Object returnValue, boolean b, int allocaPtr) {
		if (!b)
			throw new AssertionFailedException(AssertionFailedException.POSTCOND);
		return i2j_return(returnValue, allocaPtr);
	}

	// ------------------- Allocation in Memories

	/**
	 * Allocate an array of elementSize with 0 initialization of element The array header is the address of element[0] The array length is stored in the int just before the header.
	 *
	 * @param nbElements
	 *            : length of the array
	 * @param elementSize
	 *            : size in byte of one element
	 * @return the header of the array
	 */
	public static int allocateArray(int nbElements, int elementSize) {

		int header = allocateArrayNoInit(nbElements, elementSize);
		Memories.memclear(header, header, nbElements * elementSize);
		return header;
	}

	/**
	 * Allocate an int array of elementSize initialize with values. The nbElement of this array is values.length().
	 *
	 * @param nbElement
	 *            : length of the array
	 * @param elementSize
	 *            : size of one element
	 * @return the header of the array
	 */
	public static int allocateArray(int[] values) {
		int nbElements = values.length;

		int header = allocateArrayNoInit(nbElements, INT_SIZE);
		System.arraycopy(values, 0, Memories.intMemory, header >> 2, nbElements);
		// for (int i = 0; i < nbElement; i++) {
		// Memories.setInt(header + i* INT_SIZE, values[i]);
		// }

		return header;
	}

	/**
	 * Allocate a byte array of elementSize initialize with values. The nbElement of this array is values.length().
	 *
	 * @param nbElement
	 *            : length of the array
	 * @param elementSize
	 *            : size of one element
	 * @return the header of the array
	 */
	public static int allocateArray(byte[] values) {
		int nbElements = values.length;

		int header = allocateArrayNoInit(nbElements, BYTE_SIZE);
		System.arraycopy(values, 0, Memories.byteMemory, header, nbElements);
		// for (int i = 0; i < nbElement; i++) {
		// Memories.setByte(header + i* BYTE_SIZE, values[i]);
		// }

		return header;
	}

	/**
	 * Allocate a long array of elementSize initialize with values. The nbElement of this array is values.length().
	 *
	 * @param nbElement
	 *            : length of the array
	 * @param elementSize
	 *            : size of one element
	 * @return the header of the array
	 */
	public static int allocateArray(long[] values) {
		int nbElement = values.length;

		int header = allocateArrayNoInit(nbElement, LONG_SIZE);
		for (int i = 0; i < nbElement; i++) {
			Memories.setLong(header + i * LONG_SIZE, values[i]);
		}

		return header;
	}

	/**
	 * Allocate a short array of elementSize initialize with values. The nbElement of this array is values.length().
	 *
	 * @param nbElement
	 *            : length of the array
	 * @param elementSize
	 *            : size of one element
	 * @return the header of the array
	 */
	public static int allocateArray(short[] values) {
		int nbElement = values.length;

		int header = allocateArrayNoInit(nbElement, SHORT_SIZE);
		for (int i = 0; i < nbElement; i++) {
			Memories.setShort(header + i * SHORT_SIZE, values[i]);
		}

		return header;
	}

	/**
	 * Allocate a char array of elementSize initialize with values. The nbElement of this array is values.length().
	 *
	 * @param nbElement
	 *            : length of the array
	 * @param elementSize
	 *            : size of one element
	 * @return the header of the array
	 */
	public static int allocateArray(char[] values) {
		int nbElement = values.length;

		int header = allocateArrayNoInit(nbElement, CHAR_SIZE);
		for (int i = 0; i < nbElement; i++) {
			Memories.setChar(header + i * CHAR_SIZE, values[i]);
		}

		return header;
	}

	/**
	 * Allocate an double array of elementSize initialize with values. The nbElement of this array is values.length().
	 *
	 * @param nbElement
	 *            : length of the array
	 * @param elementSize
	 *            : size of one element
	 * @return the header of the array
	 */
	public static int allocateArray(double[] values) {
		int nbElement = values.length;

		int header = allocateArrayNoInit(nbElement, DOUBLE_SIZE);
		for (int i = 0; i < nbElement; i++) {
			Memories.setDouble(header + i * DOUBLE_SIZE, values[i]);
		}

		return header;
	}

	/**
	 * Allocate a boolean array of elementSize initialize with values. The nbElement of this array is values.length().
	 *
	 * @param nbElement
	 *            : length of the array
	 * @param elementSize
	 *            : size of one element
	 * @return the header of the array
	 */
	public static int allocateArray(boolean[] values) {
		int nbElement = values.length;

		int header = allocateArrayNoInit(nbElement, BOOLEAN_SIZE);
		for (int i = 0; i < nbElement; i++) {
			Memories.setBoolean(header + i * BOOLEAN_SIZE, values[i]);
		}

		return header;
	}

	/**
	 * Allocate without initialize element, an array of nbElement.
	 *
	 * @param nbElements
	 *            : length of the array
	 * @param elementSize
	 *            : size of one element
	 * @return the header of the array
	 */
	public static int allocateArrayNoInit(int nbElements, int elementSize) {

		// arrayLength is store before the array header
		int size = nbElements * elementSize + INT_SIZE;
		int callerAddress = 0; // TODO for debug

		int begin = BestFitAllocator.malloc(size /* INTSize for length */, callerAddress);
		// store the length in header-4
		Memories.intMemory[begin >> 2] = nbElements;

		if (I2JCheckConstants.ACTIVATE_CHECK) {
			if (TraceHelper.MEMORIES_HEAP_ALLOCATION) {
				TraceHelper.traceAllocation(begin + 4, nbElements, elementSize);
			}
		}

		// return the header of allocated array
		return begin + INT_SIZE;
	}

	/**
	 * Allocate an array multi dim without initialize terminal elements
	 *
	 * @param dims
	 *            : length for each dimension to initialize
	 * @param elementSize
	 *            : size in byte of terminal elements
	 * @param lastDimension
	 *            : array dimension -1
	 * @param step
	 *            : current recursion step level [ 0-array type dimension-1] when step=array type dimension-1, allocate terminal elements
	 * @return the header of the array
	 */
	public static int allocateArrayMultiDim(int[] dims, int elementSize, int lastDimension, int step) {
		// NOTE : dims.length >= 2 (otherwise use allocateArray())

		int sizeCurrentDim = dims[step];

		if (step == lastDimension) {
			// terminals elements
			return allocateArray(sizeCurrentDim, elementSize);
		} else {

			step++;
			if (step == dims.length) {
				// allocate with 0 init for null reference
				return allocateArray(sizeCurrentDim, INT_SIZE);
			} else {
				int header = allocateArrayNoInit(sizeCurrentDim, INT_SIZE);
				int offset = header + (sizeCurrentDim - 1) * INT_SIZE;
				while (offset >= header) {
					int elt = allocateArrayMultiDim(dims, elementSize, lastDimension, step);
					Memories.intMemory[offset >> 2] = elt;
					offset -= INT_SIZE;
				}
				return header;
			}
		}
	}

	/**
	 * Allocate an array multi dim with initialize terminal elements
	 *
	 * @param dims
	 *            : length for each dimension to initialize
	 * @param elementSize
	 *            : size in byte of terminal elements
	 * @param lastDimension
	 *            : array dimension -1
	 * @param step
	 *            : current recursion step level [ 0-array type dimension-1] when step=array type dimension-1, allocate terminal elements
	 * @return the header of the array
	 */

	public static int allocateArrayMultiDimNoInit(int[] dims, int elementSize, int lastDimension, int step) {
		// NOTE : dims.length >= 2 (otherwise use allocateArray())

		int sizeCurrentDim = dims[step];

		if (step == lastDimension) {
			// terminals elements
			return allocateArrayNoInit(sizeCurrentDim, elementSize);
		} else {

			step++;
			if (step == dims.length) {
				return allocateArrayNoInit(sizeCurrentDim, INT_SIZE);
			} else {
				int header = allocateArrayNoInit(sizeCurrentDim, INT_SIZE);
				int offset = header + (sizeCurrentDim - 1) * INT_SIZE;
				while (offset >= header) {
					int elt = allocateArrayMultiDimNoInit(dims, elementSize, lastDimension, step);
					Memories.intMemory[offset >> 2] = elt;
					offset -= INT_SIZE;
				}
				return header;
			}
		}

	}

	/**
	 * For freeze the object allocated in Memories at address. NOTE : DO not freeze the elements if the array is a multi dimension array
	 *
	 * @param addr
	 *            : array or struct header address in Memories
	 */
	public static void free(int addr) {
		if (I2JCheckConstants.ACTIVATE_CHECK) {
			if (TraceHelper.MEMORIES_HEAP_ALLOCATION) {
				TraceHelper.traceFree(addr);
			}
		}

		BestFitAllocator.free(addr - INT_SIZE /* length */);
	}

	/**
	 * Remove obj from IceTeaArraySupport.arrayTable if obj has been refered as Array
	 *
	 * @param obj
	 *            to freed
	 */
	public static void free(Object obj) {
		// obj should not be a kind of iceTea.lang.Object
		// -> on iceTea.lang.Object use object.free() generated in the object Class
		// nothing to do.

		IceteaArraySupport.remove(obj);
	}

	/**
	 *
	 * @param obj
	 *            to freed
	 */
	public static void free(iceTea.lang.Object obj) {
		obj.i2j_free();
	}

	public static void traceEndAllocation() {
		if (I2JCheckConstants.ACTIVATE_CHECK) {
			if (TraceHelper.MEMORIES_HEAP_ALLOCATION)
				TraceHelper.traceHeapEndAllocation();
			if (TraceHelper.MEMORIES_STACK_ALLOCATION)
				Thread.currentThread().traceEndAllocation();
		}
	}

	/**
	 * cast a byte as an unsigned byte to a char
	 *
	 * @param b
	 *            byte to cast
	 * @return the char casted
	 */
	public static char ub2c(byte b) {
		return (char) (b & 0xFF);
	}

}
