/*
 * Java
 *
 * Copyright 2008-2014 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package iceTea.lang.support;

import iceTea.lang.Memories;


/**
 * Array support :
 *  iceTea.lang.Array contains this 2 kinds of elements :
 *  address in Memories
 *  or java Object  (kind of IceTea.lang.Object or array or IceTea.lang.Object)
 *   When a java object is added in an Array an index is affected to this object (store in i2j_indexInArrayTable  Object field).
 */ 
public class IceteaArraySupport implements I2jConstants {

	private static final int DEFAULT_SIZE = 100;

	static java.lang.Object[] arrayTable;
	private static int ptrArrayTable;

	static {
		arrayTable = new java.lang.Object[DEFAULT_SIZE];
		ptrArrayTable = 0;
		arrayTable[0] = null;// 0 reserved for null
	}

	/**
	 * Add an entry in objectArrayTable for array. If array already added, return his index entry else add it
	 *
	 * @param object
	 * @return index of array in objectArrayTable
	 */
	public static int add(java.lang.Object object) {
		if (object == null)
			return 0;

		int freeIndex = -1;
		for (int i = ptrArrayTable; i > 0; i--) { // 0 reserve for null
			Object current = arrayTable[i];
			if (current == object)
				return i; // already exits : return his index
			if (current == null) {
				freeIndex = i;
			}
		}

		if (freeIndex != -1) {
			// reuse null entry
			arrayTable[freeIndex] = object;
			return freeIndex;
		} else {
			// no null entry : next available element
			try {
				arrayTable[++ptrArrayTable] = object;
			} catch (IndexOutOfBoundsException e) {
				// grow
				System.arraycopy(arrayTable, 0, arrayTable = new iceTea.lang.Object[ptrArrayTable + DEFAULT_SIZE], 0, ptrArrayTable);

				arrayTable[ptrArrayTable] = object;
			}

			return ptrArrayTable;
		}
	}

	/**
	 * remove an entry in objectArrayTable for array. If array already added, return his index entry else add it
	 *
	 * @param array
	 * @return index of array in objectArrayTable
	 */
	public static int remove(java.lang.Object object) {
		if (object == null)
			return 0;

		for (int i = ptrArrayTable; i > 0; i--) { // 0 reserve for null
			if (arrayTable[i] == object) {
				arrayTable[i] = null;
				return i;
			}
		}

		return 0;

	}

	public static int getAddress(int address) {
		return address;
	}

	/**
	 * Simulate an address for all objects (index in a global table objectArrayTable) An iceTea.lang.Object store his index in i2j_indexInArrayTable iceTea.lang.Object field Access to java.lang.Object is not optimized yet
	 *
	 * @param array
	 * @return
	 */
	public static int getAddress(Object object) {
		if (object == null)
			return 0; // index for null

		int index = add(object);

		return index;
	}

	public static void remove(int index) {
		arrayTable[index] = null;
	}

	public static java.lang.Object getObjectAt(java.lang.Object object) {
		return object;
	}

	public static java.lang.Object getObjectAt(int index) {
		return arrayTable[index];
	}

	/**
	 * Create a byte array in Memories with bytes values...
	 *
	 * @param bytes
	 *            values to copy to Memories
	 * @return address of new allocated object
	 */
	public static int fromJavaToIceteaArray(byte[] bytes) {
		int header = IceteaRuntimeSupport.allocateArrayNoInit(bytes.length, BYTE_SIZE);
		System.arraycopy(bytes, 0, Memories.byteMemory, header, bytes.length);
//		int ptr = header + bytes.length * BYTE_SIZE;
//		for (int i = bytes.length; --i >= 0;) {
//			ptr -= BYTE_SIZE;
//			Memories.setByte(ptr, bytes[i]);
//		}
//		assert (ptr == header);

		return header;
	}

	/**
	 * Copy values of bytes in Memories at start to start+size Suppose off is an address in a byte[] store in Memories ...
	 *
	 * @param off
	 *            : first address to write in Memories
	 * @param size
	 *            : nb byte to write
	 * @param bytes
	 *            :
	 */
	public static void fromJavaToIceteaArray(byte[] bytes, int start, int size) {
		System.arraycopy(bytes, 0, Memories.byteMemory, start, size);
//		int ptr = start + size * BYTE_SIZE;
//		for (int i = size; --i >= 0;) {
//			ptr -= BYTE_SIZE;
//			Memories.setByte(ptr, bytes[i]);
//		}
//
//		if (I2JCheckConstants.ACTIVATE_CHECK)
//			IceteaRuntimeSupport.assertCheck(ptr == start);
	}

	/**
	 * copy all bytes of Memories from start to start+size in bytes
	 *
	 * @param bytes
	 *            values to copy to Memories
	 * @return address of new allocated object
	 */
	public static void fromIceTeaToJavaArray(int start, int size, byte[] bytes) {
		System.arraycopy(Memories.byteMemory, start, bytes, 0, size);
//		int ptr = start + size * BYTE_SIZE;
//		for (int i = size; --i >= 0;) {
//			ptr -= BYTE_SIZE;
//			bytes[i] = Memories.getByte(ptr);
//		}
//
//		if (I2JCheckConstants.ACTIVATE_CHECK)
//			IceteaRuntimeSupport.assertCheck(ptr == start);
	}

	/**
	 * copy all bytes of Memories from start to start+size in bytes
	 *
	 * @param bytes
	 *            values to copy to Memories
	 * @return address of new allocated object
	 */
	public static byte[] fromIceTeaToJavaArray(int start, int size) {
		byte[] bytes = new byte[size];
		fromIceTeaToJavaArray(start, size, bytes);
		return bytes;
	}

	/**
	 * Array Size support
	 *
	 * @param header
	 * @return
	 */
	public static int length(int array) {
		return Memories.intMemory[(array - INT_SIZE) >> 2];
	}

	/**
	 * For debug : print the corresponding String
	 *
	 * @param bytes
	 * @return
	 */
	public static java.lang.String toString(int bytes) {
		return IceteaStringSupport.fromIceTeaByteArrayToJavaString(bytes, IceteaArraySupport.length(bytes));
	}

}
