/*
 * Java
 *
 * Copyright 2009-2020 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package iceTea.lang;

import iceTea.lang.support.I2jConstants;
import iceTea.lang.support.IceteaStringSupport;


public class SystemOut  extends iceTea.lang.Object implements I2jConstants {

	public static void printAsciiCharacter(byte character){
		System.defaultOutputStream.print((char)(character&0xFF));
	}
	public static void print(boolean b){
		System.defaultOutputStream.print(b);
	}
	public static void print(byte b){
		System.defaultOutputStream.print(b);
	}
	public static void print(char c){
		System.defaultOutputStream.print(c);
	}
	public static void printCharValue(char c){
		System.defaultOutputStream.print((int)c);
	}
	public static void print(short s){
		System.defaultOutputStream.print(s);
	}
	public static void print(int i){
		System.defaultOutputStream.print(i);
	}
	public static void print(long l){
		System.defaultOutputStream.print(l);
	}

	public static void print(String str) {
		System.defaultOutputStream.write(Memories.getBytes(str.chars), 0, str.length);
	}

	public static void printFree(String str){
		print(str);
		str.dispose();
	}

	public static void print(byte[] chars){
		System.defaultOutputStream.write(chars, 0, chars.length);
	}

	public static void print___3B(int chars) {
		byte[] bytes = Memories.toJavaByte(chars);
		System.defaultOutputStream.write(bytes, 0, bytes.length);
	}

	public static void print___3BII(int chars, int offset, int length) {
		byte[] bytes = Memories.toJavaByte(chars);
		System.defaultOutputStream.write(bytes, offset, length);
	}

	public static void print(byte[] chars, short offset, short length) {
		System.defaultOutputStream.write(chars, offset, length);
	}

	public static void print(byte[] chars, int offset, int length) {
		System.defaultOutputStream.write(chars, offset, length);
	}

	/** IST-API */
	public static void println(){
		printAsciiCharacter((byte)'\n');
	}
	/** IST-API */
	public static void println(boolean x){
		System.defaultOutputStream.println(x);
	}
	/** IST-API */
	public static void println(byte b){
		System.defaultOutputStream.println(b);
	}
	/** IST-API */
	public static void printlnAsciiCharacter(byte b){
		System.defaultOutputStream.println((char)b);
	}
	public static void println(char x){
		System.defaultOutputStream.println(x);
	}
	public static void printlnCharValue(char c){
		System.defaultOutputStream.println((int)c);
	}
	public static void println(short s){
		System.defaultOutputStream.println(s);
	}
	public static void println(int x){
		System.defaultOutputStream.println(x);
	}
	public static void println(long x){
		System.defaultOutputStream.println(x);
	}
	public static void println(String str){
		print(str);
		System.defaultOutputStream.print('\n');
	}
	public static void printlnFree(String str){
		print(str);
		System.defaultOutputStream.print('\n');
		str.dispose();
	}

	public static void println(java.lang.String str){
		println(IceteaStringSupport.internString( str));
	}

	public static void printlnFree(java.lang.String str){
		printlnFree(IceteaStringSupport.internString( str));
	}


	public static void println(byte[] s){
		print(s);
		println();
	}
	public static void println(byte[] chars, short offset, short length){
		print(chars, offset, length);
		println();
	}
	public static void println(byte[] chars, int offset, int length){
		print(chars, offset, length);
		println();
	}
}
