/*
 * Created on 23-Mar-2004
 */
package iceTea.lang;

import iceTea.lang.support.IceteaExitException;


/**
 * @author IST
 * 
 * The System class contains several useful class fields and methods. It cannot be instantiated.
 */
/** 
 * IST-FIELD-API = errno
 * IST-FIELD-API = out 
 * */
public final class System extends Object {
	
    // Like the C system global      
    public static byte errno;   
    
	/**
	 * The "standard" output stream. This stream is already open and ready to
	 * accept output data. Typically this stream corresponds to display output
	 * or another output destination specified by the host environment or user.
	 * 
	 * For simple stand-alone Java applications, a typical way to write a line
	 * of output data is:
	 * 
	 *                System.out.println(data)
	 * 
	 * See the println methods in class PrintStream.
	 */
    public static final iceTea.lang.SystemOut out = new SystemOut(); //  unique init (only static methods)  
    
    public static final java.io.PrintStream defaultOutputStream;
    private native static iceTea.io.OutputStream getOutputStream();
    static {
        defaultOutputStream = java.lang.System.out;
    }
	/**
	 * The "standard" error output stream. This stream is already open and ready to
	 * accept output data.
	 * 
	 * Typically this stream corresponds to display output or another output
	 * destination specified by the host environment or user. By convention, this
	 * output stream is used to display error messages or other information that
	 * should come to the immediate attention of a user even if the principal
	 * output stream, the value of the variable out, has been redirected to a file
	 * or other destination that is typically not continuously monitored.
	 */
//	public static final PrintStream err = defaultOutputStream ;
	

	/**
	 * Copies an array from the specified source array, beginning at the
	 * specified position, to the specified position of the destination array.
	 * A subsequence of array components are copied from the source array
	 * referenced by src to the destination array referenced by dst. The number
	 * of components copied is equal to the length argument. The components at
	 * positions srcOffset through srcOffset+length-1 in the source array are
	 * copied into positions dstOffset through dstOffset+length-1,
	 * respectively, of the destination array.
	 * 
	 * If the src and dst arguments refer to the same array object, then the
	 * copying is performed as if the components at positions srcOffset through
	 * srcOffset+length-1 were first copied to a temporary array with length
	 * components and then the contents of the temporary array were copied into
	 * positions dstOffset through dstOffset+length-1 of the destination array.
	 * 
	 * If dst is null, then a NullPointerException is thrown.
	 * 
	 * If src is null, then a NullPointerException is thrown and the
	 * destination array is not modified.
	 * 
	 * Otherwise, if any of the following is true, an ArrayStoreException is
	 * thrown and the destination is not modified: The src argument refers to
	 * an object that is not an array. The dst argument refers to an object
	 * that is not an array. The src argument and dst argument refer to arrays
	 * whose component types are different primitive types. The src argument
	 * refers to an array with a primitive component type and the dst argument
	 * refers to an array with a reference component type. The src argument
	 * refers to an array with a reference component type and the dst argument
	 * refers to an array with a primitive component type.
	 * 
	 * Otherwise, if any of the following is true, an IndexOutOfBoundsException
	 * is thrown and the destination is not modified: The srcOffset argument is
	 * negative. The dstOffset argument is negative. The length argument is
	 * negative. srcOffset+length is greater than src.length, the length of the
	 * source array. dstOffset+length is greater than dst.length, the length of
	 * the destination array.
	 * 
	 * Otherwise, if any actual component of the source array from position
	 * srcOffset through srcOffset+length-1 cannot be converted to the
	 * component type of the destination array by assignment conversion, an
	 * ArrayStoreException is thrown. In this case, let k be the smallest
	 * nonnegative integer less than length such that src[srcOffset+k] cannot
	 * be converted to the component type of the destination array; when the
	 * exception is thrown, source array components from positions srcOffset
	 * through srcOffset+k-1 will already have been copied to destination array
	 * positions dstOffset through dstOffset+k-1 and no other positions of the
	 * destination array will have been modified. (Because of the restrictions
	 * already itemized, this paragraph effectively applies only to the
	 * situation where both arrays have component types that are reference
	 * types.)
	 */
	public static void arraycopy(java.lang.Object src, int srcOffset, java.lang.Object dst, int dstOffset, int length){
	    java.lang.System.arraycopy(src, srcOffset, dst, dstOffset, length);   
    }
	
	
//	/** IST-API */
//	public static void arraycopy(boolean[] src, int srcOffset, boolean[] dst, int dstOffset, int length){
//		arraycopy((Object)src, srcOffset, (Object)dst, dstOffset, length);
//	}
//	/** IST-API */
//	public static void arraycopy(boolean[] src, short srcOffset, boolean[] dst, short dstOffset, short length){
//	    arraycopy((Object)src, (int)srcOffset, (Object)dst, (int)dstOffset, (int)length);
//	}
//	/** IST-API */
//	public static void arraycopy(boolean[] src, char srcOffset, boolean[] dst, char dstOffset, char length){
//	    arraycopy((Object)src, (int)srcOffset, (Object)dst, (int)dstOffset, (int)length);
//	}
//	/** IST-API */
//	public static void arraycopy(byte[] src, int srcOffset, byte[] dst, int dstOffset, int length){
//		arraycopy((Object)src, srcOffset, (Object)dst, dstOffset, length);
//	}
//	/** IST-API */
//	public static void arraycopy(byte[] src, short srcOffset, byte[] dst, short dstOffset, short length){
//	    arraycopy((Object)src, (int)srcOffset, (Object)dst, (int)dstOffset, (int)length);
//	}
//	/** IST-API */
//	public static void arraycopy(byte[] src, char srcOffset, byte[] dst, char dstOffset, char length){
//	    arraycopy((Object)src, (int)srcOffset, (Object)dst, (int)dstOffset, (int)length);
//	}
//	/** IST-API */
//	public static void arraycopy(char[] src, int srcOffset, char[] dst, int dstOffset, int length){
//		arraycopy((Object)src, srcOffset, (Object)dst, dstOffset, length);
//	}
//	/** IST-API */
//	public static void arraycopy(char[] src, short srcOffset, char[] dst, short dstOffset, short length){
//	    arraycopy((Object)src, (int)srcOffset, (Object)dst, (int)dstOffset, (int)length);
//	}
//	/** IST-API */
//	public static void arraycopy(char[] src, char srcOffset, char[] dst, char dstOffset, char length){
//	    arraycopy((Object)src, (int)srcOffset, (Object)dst, (int)dstOffset, (int)length);
//	}
//	/** IST-API */
//	public static void arraycopy(short[] src, int srcOffset, short[] dst, int dstOffset, int length){
//		arraycopy((Object)src, srcOffset, (Object)dst, dstOffset, length);
//	}
//	/** IST-API */
//	public static void arraycopy(short[] src, short srcOffset, short[] dst, short dstOffset, short length){
//	    arraycopy((Object)src, (int)srcOffset, (Object)dst, (int)dstOffset, (int)length);
//	}
//	/** IST-API */
//	public static void arraycopy(short[] src, char srcOffset, short[] dst, char dstOffset, char length){
//	    arraycopy((Object)src, (int)srcOffset, (Object)dst, (int)dstOffset, (int)length);
//	}
//	/** IST-API */
//	public static void arraycopy(int[] src, int srcOffset, int[] dst, int dstOffset, int length){
//		arraycopy((Object)src, srcOffset, (Object)dst, dstOffset, length);
//	}
//	/** IST-API */
//	public static void arraycopy(int[] src, short srcOffset, int[] dst, short dstOffset, short length){
//	    arraycopy((Object)src, (int)srcOffset, (Object)dst, (int)dstOffset, (int)length);
//	}
//	/** IST-API */
//	public static void arraycopy(int[] src, char srcOffset, int[] dst, char dstOffset, char length){
//	    arraycopy((Object)src, (int)srcOffset, (Object)dst, (int)dstOffset, (int)length);
//	}
//	/** IST-API */
//	public static void arraycopy(long[] src, int srcOffset, long[] dst, int dstOffset, int length){
//		arraycopy((Object)src, srcOffset, (Object)dst, dstOffset, length);
//	}
//	/** IST-API */
//	public static void arraycopy(long[] src, short srcOffset, long[] dst, short dstOffset, short length){
//	    arraycopy((Object)src, (int)srcOffset, (Object)dst, (int)dstOffset, (int)length);
//	}
//	/** IST-API */
//	public static void arraycopy(long[] src, char srcOffset, long[] dst, char dstOffset, char length){
//	    arraycopy((Object)src, (int)srcOffset, (Object)dst, (int)dstOffset, (int)length);
//	}
//	/** IST-API */
//	public static void arraycopy(float[] src, int srcOffset, float[] dst, int dstOffset, int length){
//		arraycopy((Object)src, srcOffset, (Object)dst, dstOffset, length);
//	}
//	/** IST-API */
//	public static void arraycopy(float[] src, short srcOffset, float[] dst, short dstOffset, short length){
//	    arraycopy((Object)src, (int)srcOffset, (Object)dst, (int)dstOffset, (int)length);
//	}
//	/** IST-API */
//	public static void arraycopy(float[] src, char srcOffset, float[] dst, char dstOffset, char length){
//	    arraycopy((Object)src, (int)srcOffset, (Object)dst, (int)dstOffset, (int)length);
//	}
//	/** IST-API */
//	public static void arraycopy(double[] src, int srcOffset, double[] dst, int dstOffset, int length){
//		arraycopy((Object)src, srcOffset, (Object)dst, dstOffset, length);
//	}
//	/** IST-API */
//	public static void arraycopy(double[] src, short srcOffset, double[] dst, short dstOffset, short length){
//	    arraycopy((Object)src, (int)srcOffset, (Object)dst, (int)dstOffset, (int)length);
//	}
//	/** IST-API */
//	public static void arraycopy(double[] src, char srcOffset, double[] dst, char dstOffset, char length){
//	    arraycopy((Object)src, (int)srcOffset, (Object)dst, (int)dstOffset, (int)length);
//	}
//	/** IST-API */
//	public static void arraycopy(Object[] src, int srcOffset, Object[] dst, int dstOffset, int length){
//		arraycopy((Object)src, srcOffset, (Object)dst, dstOffset, length);
//	}
//	/** IST-API */
//	public static void arraycopy(Object[] src, short srcOffset, Object[] dst, short dstOffset, short length){
//	    arraycopy((Object)src, (int)srcOffset, (Object)dst, (int)dstOffset, (int)length);
//	}
//	/** IST-API */
//	public static void arraycopy(Object[] src, char srcOffset, Object[] dst, char dstOffset, char length){
//	    arraycopy((Object)src, (int)srcOffset, (Object)dst, (int)dstOffset, (int)length);
//	}
	
	/** Returns the current time in milliseconds. 
	 */
	/** IST-API */
	public static long currentTimeMillis(){
		// Easy support : redirect to java currentTimeMillis !!!
		return java.lang.System.currentTimeMillis();
	}

	/**
	 * Terminates the currently running Java application. The argument serves
	 * as a status code; by convention, a nonzero status code indicates
	 * abnormal termination.
	 * 
	 * This method calls the exit method in class Runtime. This method never
	 * returns normally.
	 * 
	 * The call System.exit(n) is effectively equivalent to the call:
	 * 
	 *              Runtime.getRuntime().exit(n)
	 */
	/** IST-API */
	public static void exit(byte status) {
            throw new IceteaExitException("Exit "+status);
	}

	/** IST-API */
	// reset the device
	public static native void reset();
	
	
	/** IST-API */
    public static void disableInterruptions(){/*IceTeaDevice.runningDevice().disableInterruptionsDevice();*/}
    /** IST-API */
    public static void enableInterruptions(){/*IceTeaDevice.runningDevice().enableInterruptionsDevice();*/}
	
	
	
	/**
	 * Runs the garbage collector.
	 * 
	 * Calling the gc method suggests that the Java Virtual Machine expend
	 * effort toward recycling unused objects in order to make the memory they
	 * currently occupy available for quick reuse. When control returns from
	 * the method call, the Java Virtual Machine has made a best effort to
	 * reclaim space from all discarded objects.
	 * 
	 * The call System.gc() is effectively equivalent to the call:
	 * 
	 * Runtime.getRuntime().gc()
	 */
	native public static void gc() ;

	/*
	 *  Gets the system property indicated by the specified key. 
	 * Assumes that key is not null and key.length() > 0
	 */
	native public static String getPropertyNative(String key) ;
	
	/** Gets the system property indicated by the specified key. 
	 */
	public static String getProperty(String key) {
        //return null when no property named key exists
	    if (key == null)
	        throw new NullPointerException() ;
	    if (key.length()==0)
	        throw new IllegalArgumentException() ;
	    return getPropertyNative(key) ;
	}

	/**
	 * Returns the same hashcode for the given object as would be returned by
	 * the default method hashCode(), whether or not the given object's class
	 * overrides hashCode(). The hashcode for the null reference is zero.
	 */
	public static int identityHashCode(Object x) {
		if (x==null)
			return 0 ;
		else
			return x.hashCode() ; // TODO: return Object.hashcode() event if
								  // x overrides hashcode().
	}
	
}
