package iceTea.lang;

import iceTea.lang.support.IceteaStringSupport;
import iceTea.lang.support.IceteaRuntimeSupport;
import iceTea.lang.StringBuilder;
import iceTea.lang.String;
import iceTea.lang.Object;
import iceTea.lang.Memories;
import iceTea.lang.Array;

public final class StringBuilder extends Object{

	public int sharedCharArrayLength;
	public int sharedCharArray;/*public byte[] sharedCharArray ;*/
	private static final int DEFAULT_INCR = 16;
	
	public StringBuilder() {
		this(16);
	}
	public StringBuilder(char length) {
		this((int)length);
	}
	public StringBuilder(int length) {
		super();
		this.sharedCharArray = IceteaRuntimeSupport.allocateArrayNoInit(length + 1, 1)/*new byte[length+1];*/;
		this.sharedCharArrayLength = 0;
		Memories.byteMemory[(this.sharedCharArray + (length * 1))/*(this.sharedCharArray)[length];*/] = (byte)1;
	}
	public StringBuilder(String str) {
		this(str, 16);
	}
	public StringBuilder(String str, int capacity) {
		this(str.length + capacity);
		this.sharedCharArrayLength = str.length;
		Array.copy8Bits(str.chars, 0, this.sharedCharArray, 0, this.sharedCharArrayLength);
	}
	public StringBuilder(String str, char capacity) {
		this(str, (int)capacity);
	}
	
	public final StringBuilder append(boolean b) {
		int sharedByteArrayLength = this.sharedCharArrayLength;
		if(b) {
			this.growAndCopyIfShared(sharedByteArrayLength + 4);
			int sharedCharArray = this.sharedCharArray;/*byte[] sharedCharArray = this.sharedCharArray;*/
			Memories.byteMemory[(sharedCharArray + ((sharedByteArrayLength++) * 1))/*(sharedCharArray)[sharedByteArrayLength++];*/] = (byte)116;
			Memories.byteMemory[(sharedCharArray + ((sharedByteArrayLength++) * 1))/*(sharedCharArray)[sharedByteArrayLength++];*/] = (byte)114;
			Memories.byteMemory[(sharedCharArray + ((sharedByteArrayLength++) * 1))/*(sharedCharArray)[sharedByteArrayLength++];*/] = (byte)117;
			Memories.byteMemory[(sharedCharArray + ((sharedByteArrayLength++) * 1))/*(sharedCharArray)[sharedByteArrayLength++];*/] = (byte)101;
		}
		else {
			this.growAndCopyIfShared(sharedByteArrayLength + 5);
			int sharedCharArray = this.sharedCharArray;/*byte[] sharedCharArray = this.sharedCharArray;*/
			Memories.byteMemory[(sharedCharArray + ((sharedByteArrayLength++) * 1))/*(sharedCharArray)[sharedByteArrayLength++];*/] = (byte)102;
			Memories.byteMemory[(sharedCharArray + ((sharedByteArrayLength++) * 1))/*(sharedCharArray)[sharedByteArrayLength++];*/] = (byte)97;
			Memories.byteMemory[(sharedCharArray + ((sharedByteArrayLength++) * 1))/*(sharedCharArray)[sharedByteArrayLength++];*/] = (byte)108;
			Memories.byteMemory[(sharedCharArray + ((sharedByteArrayLength++) * 1))/*(sharedCharArray)[sharedByteArrayLength++];*/] = (byte)115;
			Memories.byteMemory[(sharedCharArray + ((sharedByteArrayLength++) * 1))/*(sharedCharArray)[sharedByteArrayLength++];*/] = (byte)101;
		}
		
		this.sharedCharArrayLength = sharedByteArrayLength;
		return this;
	}
	public final StringBuilder append___3BII(int str, int offset, int len) {
		if(len > 0) {
			int sharedCharArrayLength = this.sharedCharArrayLength;
			this.growAndCopyIfShared(len + sharedCharArrayLength);
			int sharedCharArray = this.sharedCharArray;/*byte[] sharedCharArray = this.sharedCharArray;*/
			int end = offset + len;
			
			while (offset < end){
				Memories.byteMemory[(sharedCharArray + ((sharedCharArrayLength++) * 1))/*(sharedCharArray)[sharedCharArrayLength++];*/] = (byte)(Memories.byteMemory)[(str + ((offset++) * 1))/*(str)[offset++];*/];
			}
			
			this.sharedCharArrayLength = sharedCharArrayLength;
		}
		
		return this;
	}
	public final StringBuilder append___3BCC(int str, char offset, char len) {
		return this.append___3BII(str, (int)offset, (int)len);
	}
	public final StringBuilder append___3B(int str) {
		return this.append___3BII(str, 0, Memories.intMemory[((str - 4)/*length*/ >> 2)]);
	}
	public final StringBuilder appendAsciiCharacter(byte c) {
		int sharedCharArrayLength = this.sharedCharArrayLength;
		this.growAndCopyIfShared(sharedCharArrayLength + 1);
		Memories.byteMemory[(this.sharedCharArray + ((sharedCharArrayLength++) * 1))/*(this.sharedCharArray)[sharedCharArrayLength++];*/] = c;
		this.sharedCharArrayLength = sharedCharArrayLength;
		return this;
	}
	public final StringBuilder append(byte b) {
		return this.append((int)b);
	}
	public final StringBuilder append(short s) {
		return this.append((int)s);
	}
	public final StringBuilder append(char c) {
		return this.appendAsciiCharacter((byte)c);
	}
	public final StringBuilder appendCharValue(char c) {
		return this.append((int)c);
	}
	public final StringBuilder append(int i) {
		int sharedCharArrayLength = this.sharedCharArrayLength;
		this.growAndCopyIfShared(sharedCharArrayLength + 11);
		int sharedCharArray = this.sharedCharArray;/*byte[] sharedCharArray = this.sharedCharArray;*/
		this.sharedCharArrayLength = String.intToByteArray(sharedCharArray, i, sharedCharArrayLength);
		return this;
	}
	public final StringBuilder append(long l) {
		int sharedCharArrayLength = this.sharedCharArrayLength;
		this.growAndCopyIfShared(sharedCharArrayLength + 21);
		int sharedCharArray = this.sharedCharArray;/*byte[] sharedCharArray = this.sharedCharArray;*/
		this.sharedCharArrayLength = String.longToByteArray(sharedCharArray, l, sharedCharArrayLength);
		return this;
	}
	public final StringBuilder append(Object obj) {
		this.append('@');
		return this.append(obj.hashCode());
	}
	public final StringBuilder append(String str) {
		if(str == null) {
			int sharedCharArrayLength = this.sharedCharArrayLength;
			int sharedCharArray = this.sharedCharArray;/*byte[] sharedCharArray = this.sharedCharArray;*/
			this.growAndCopyIfShared(sharedCharArrayLength + 4);
			Memories.byteMemory[(sharedCharArray + ((sharedCharArrayLength++) * 1))/*(sharedCharArray)[sharedCharArrayLength++];*/] = (byte)110;
			Memories.byteMemory[(sharedCharArray + ((sharedCharArrayLength++) * 1))/*(sharedCharArray)[sharedCharArrayLength++];*/] = (byte)117;
			Memories.byteMemory[(sharedCharArray + ((sharedCharArrayLength++) * 1))/*(sharedCharArray)[sharedCharArrayLength++];*/] = (byte)108;
			Memories.byteMemory[(sharedCharArray + ((sharedCharArrayLength++) * 1))/*(sharedCharArray)[sharedCharArrayLength++];*/] = (byte)108;
			this.sharedCharArrayLength = sharedCharArrayLength;
		}
		else 
			this.append___3BII(str.chars, 0, str.length);
		
		return this;
	}
	public final int capacity() {
		return (Memories.intMemory)[((this.sharedCharArray - 4)/*length*/ >> 2)] - 1;
	}
	public final byte charAt(int index) {
		return (byte)(Memories.byteMemory)[(this.sharedCharArray + (index * 1))/*(this.sharedCharArray)[index];*/];
	}
	public final byte charAt(char index) {
		return this.charAt((int)index);
	}
	public final StringBuilder remove(int start, int end) {
		if(start < end) {
			int sharedCharArrayLength = this.sharedCharArrayLength;
			int newLength = sharedCharArrayLength - (end - start);
			int srcArray = this.sharedCharArray;/*byte[] srcArray = this.sharedCharArray;*/
			int dstArray = srcArray;/*byte[] dstArray = srcArray;*/
			if(this.isShared()) {
				int capacity = Memories.intMemory[((this.sharedCharArray - 4)/*length*/ >> 2)];
				int newArray = IceteaRuntimeSupport.allocateArrayNoInit(capacity, 1)/*new byte[capacity];*/;/*byte[] newArray = new byte[capacity];*/
				if(start > 0) 
					Array.copy8Bits(this.sharedCharArray, 0, dstArray, 0, start);
				
				this.dispose();
				Memories.byteMemory[(newArray + ((capacity - 1) * 1))/*(newArray)[capacity-1];*/] = (byte)1;
				this.sharedCharArray = newArray;
				if(start > 0) 
					Array.copy8Bits(srcArray, 0, dstArray, 0, start);
				
			}
			
			int nbCharsToShift = sharedCharArrayLength - end;
			if(nbCharsToShift > 0) 
				Array.copy8Bits(srcArray, end, dstArray, start, nbCharsToShift);
			
			this.sharedCharArrayLength = newLength;
		}
		
		return this;
	}
	public final StringBuilder remove(char start, char end) {
		return this.remove((int)start, (int)end);
	}
	public final StringBuilder removeCharAt(int index) {
		return this.remove(index, index + 1);
	}
	public final StringBuilder removeCharAt(char index) {
		return this.removeCharAt((int)index);
	}
	public final void ensureCapacity(int minimumCapacity) {
		this.growAndCopyIfShared(minimumCapacity);
	}
	public boolean isShared() {
		return ((byte)(Memories.byteMemory)[(this.sharedCharArray + (((Memories.intMemory)[((this.sharedCharArray - 4)/*length*/ >> 2)] - 1) * 1))/*(this.sharedCharArray)[this.sharedCharArray.length-1];*/]) > 1;
	}
	public final void ensureCapacity(char minimumCapacity) {
		this.growAndCopyIfShared((int)minimumCapacity);
	}
	public final void getChars__II_3BI(int srcBegin, int srcEnd, int dst, int dstBegin) {
		Array.copy8Bits(this.sharedCharArray, srcBegin, dst, dstBegin, srcEnd - srcBegin);
	}
	public final void getChars__CC_3BC(char srcBegin, char srcEnd, int dst, char dstBegin) {
		this.getChars__II_3BI((int)srcBegin, (int)srcEnd, dst, (int)dstBegin);
	}
	public final StringBuilder insert(int offset, boolean b) {
		if(b) {
			this.shiftChars(offset, 4);
			int sharedCharArray = this.sharedCharArray;/*byte[] sharedCharArray = this.sharedCharArray;*/
			Memories.byteMemory[(sharedCharArray + ((offset++) * 1))/*(sharedCharArray)[offset++];*/] = (byte)116;
			Memories.byteMemory[(sharedCharArray + ((offset++) * 1))/*(sharedCharArray)[offset++];*/] = (byte)114;
			Memories.byteMemory[(sharedCharArray + ((offset++) * 1))/*(sharedCharArray)[offset++];*/] = (byte)117;
			Memories.byteMemory[(sharedCharArray + (offset * 1))/*(sharedCharArray)[offset];*/] = (byte)101;
		}
		else {
			this.shiftChars(offset, 5);
			int sharedCharArray = this.sharedCharArray;/*byte[] sharedCharArray = this.sharedCharArray;*/
			Memories.byteMemory[(sharedCharArray + ((offset++) * 1))/*(sharedCharArray)[offset++];*/] = (byte)102;
			Memories.byteMemory[(sharedCharArray + ((offset++) * 1))/*(sharedCharArray)[offset++];*/] = (byte)97;
			Memories.byteMemory[(sharedCharArray + ((offset++) * 1))/*(sharedCharArray)[offset++];*/] = (byte)108;
			Memories.byteMemory[(sharedCharArray + ((offset++) * 1))/*(sharedCharArray)[offset++];*/] = (byte)115;
			Memories.byteMemory[(sharedCharArray + (offset * 1))/*(sharedCharArray)[offset];*/] = (byte)101;
		}
		
		return this;
	}
	public final StringBuilder insert(char offset, boolean b) {
		return this.insert((int)offset, b);
	}
	public final StringBuilder insert(int offset, char c) {
		return this.insertAsciiCharacter(offset, (byte)c);
	}
	public final StringBuilder insert(char offset, char c) {
		return this.insert((int)offset, c);
	}
	public final StringBuilder insert(int offset, double d) {
		return this;
	}
	public final StringBuilder insert(int offset, float f) {
		return this;
	}
	public final StringBuilder insert(char offset, double d) {
		return this.insert((int)offset, d);
	}
	public final StringBuilder insert(char offset, float f) {
		return this.insert((int)offset, f);
	}
	public final StringBuilder insertAsciiCharacter(int offset, byte c) {
		this.shiftChars(offset, 1);
		Memories.byteMemory[(this.sharedCharArray + (offset * 1))/*(this.sharedCharArray)[offset];*/] = c;
		return this;
	}
	public final StringBuilder insertAsciiCharacter(char offset, byte c) {
		return this.insertAsciiCharacter((int)offset, c);
	}
	public final StringBuilder insertCharValue(int offset, char c) {
		return this.insert(offset, (int)c);
	}
	public final StringBuilder insertCharValue(char offset, char c) {
		return this.insertCharValue((int)offset, c);
	}
	public final StringBuilder insert(int offset, byte c) {
		return this.insert(offset, (int)c);
	}
	public final StringBuilder insert(char offset, byte c) {
		return this.insert((int)offset, c);
	}
	public final StringBuilder insert__I_3B(int offset, int str) {
		int strlen = Memories.intMemory[((str - 4)/*length*/ >> 2)];
		this.shiftChars(offset, strlen);
		int index = 0;
		int sharedCharArray = this.sharedCharArray;/*byte[] sharedCharArray = this.sharedCharArray;*/
		
		while (index < strlen)Memories.byteMemory[(sharedCharArray + ((offset++) * 1))/*(sharedCharArray)[offset++];*/] = (byte)(Memories.byteMemory)[(str + ((index++) * 1))/*(str)[index++];*/];
		return this;
	}
	public final StringBuilder insert__C_3B(char offset, int str) {
		return this.insert__I_3B((int)offset, str);
	}
	public final StringBuilder insert(int offset, int i) {
		int array = (int)IceteaRuntimeSupport.allocateArrayNoInit(11, 1)/*new byte[iceTea.lang.String.IntNumberMaxDigits];*/;/*byte[] array = ((byte[])(new byte[iceTea.lang.String.IntNumberMaxDigits]));*/
		int len = String.intToByteArray(array, i, 0);
		this.shiftChars(offset, len);
		Array.copy8Bits(array, 0, this.sharedCharArray, offset, len);
		return this;
	}
	public final StringBuilder insert(char offset, int i) {
		return this.insert((int)offset, i);
	}
	public final StringBuilder insert(int offset, long l) {
		int array = (int)IceteaRuntimeSupport.allocateArrayNoInit(21, 1)/*new byte[iceTea.lang.String.LongNumberMaxDigits];*/;/*byte[] array = ((byte[])(new byte[iceTea.lang.String.LongNumberMaxDigits]));*/
		int len = String.longToByteArray(array, l, 0);
		this.shiftChars(offset, len);
		Array.copy8Bits(array, 0, this.sharedCharArray, offset, len);
		return this;
	}
	public final StringBuilder insert(char offset, long l) {
		return this.insert((int)offset, l);
	}
	public final StringBuilder insert(int offset, Object obj) {
		this.insert(offset, '@');
		return this.insert(offset + 1, obj.hashCode());
	}
	public final StringBuilder insert(char offset, Object obj) {
		return this.insert((int)offset, obj);
	}
	public final StringBuilder insert(int offset, String str) {
		if(str == null) {
			this.shiftChars(offset, 4);
			int sharedCharArray = this.sharedCharArray;/*byte[] sharedCharArray = this.sharedCharArray;*/
			Memories.byteMemory[(sharedCharArray + ((offset++) * 1))/*(sharedCharArray)[offset++];*/] = (byte)110;
			Memories.byteMemory[(sharedCharArray + ((offset++) * 1))/*(sharedCharArray)[offset++];*/] = (byte)117;
			Memories.byteMemory[(sharedCharArray + ((offset++) * 1))/*(sharedCharArray)[offset++];*/] = (byte)108;
			Memories.byteMemory[(sharedCharArray + (offset * 1))/*(sharedCharArray)[offset];*/] = (byte)108;
			return this;
		}
		
		int strLength = str.length;
		this.shiftChars(offset, strLength);
		Array.copy8Bits(str.chars, 0, this.sharedCharArray, offset, strLength);
		return this;
	}
	public final StringBuilder insert(char offset, String str) {
		return this.insert((int)offset, str);
	}
	public final int length() {
		return this.sharedCharArrayLength;
	}
	public final StringBuilder reverse() {
		int sharedCharArray = this.sharedCharArray;/*byte[] sharedCharArray = this.sharedCharArray;*/
		int sharedCharArrayLength = this.sharedCharArrayLength;
		if(!this.isShared()) {
			int start = 0;
			int loop = sharedCharArrayLength / 2;
			byte c;
			
			while ((--loop) >= 0){
				c = (byte)(Memories.byteMemory)[(sharedCharArray + (start * 1))/*(sharedCharArray)[start];*/];
				Memories.byteMemory[(sharedCharArray + ((start++) * 1))/*(sharedCharArray)[start++];*/] = (byte)(Memories.byteMemory)[(sharedCharArray + ((--sharedCharArrayLength) * 1))/*(sharedCharArray)[--sharedCharArrayLength];*/];
				Memories.byteMemory[(sharedCharArray + (sharedCharArrayLength * 1))/*(sharedCharArray)[sharedCharArrayLength];*/] = c;
			}
			
		}
		else {
			int newArray = IceteaRuntimeSupport.allocateArrayNoInit(Memories.intMemory[((sharedCharArray - 4)/*length*/ >> 2)], 1)/*new byte[sharedCharArray.length];*/;/*byte[] newArray = new byte[sharedCharArray.length];*/
			int i = sharedCharArrayLength;
			int j = -1;
			
			while ((--i) >= 0)Memories.byteMemory[(newArray + ((++j) * 1))/*(newArray)[++j];*/] = (byte)(Memories.byteMemory)[(sharedCharArray + (i * 1))/*(sharedCharArray)[i];*/];
			this.dispose();
			Memories.byteMemory[(newArray + ((Memories.intMemory)[((sharedCharArray - 4)/*length*/ >> 2)] * 1))/*(newArray)[sharedCharArray.length];*/] = (byte)1;
			this.sharedCharArray = newArray;
		}
		
		return this;
	}
	public final void setCharAt(int index, byte ch) {
		if(this.isShared()) 
			this.copyChars(Memories.intMemory[((this.sharedCharArray - 4)/*length*/ >> 2)], this.sharedCharArrayLength);
		
		Memories.byteMemory[(this.sharedCharArray + (index * 1))/*(this.sharedCharArray)[index];*/] = ch;
	}
	public final void setCharAt(char index, byte ch) {
		this.setCharAt((int)index, ch);
	}
	public final void setLength(int newLength) {
		int sharedCharArrayLength = this.sharedCharArrayLength;
		if(newLength == sharedCharArrayLength) 
			return;
		
		this.growAndCopyIfShared(newLength);
		if(newLength > sharedCharArrayLength) {
			int sharedByteArray = this.sharedCharArray;/*byte[] sharedByteArray = this.sharedCharArray;*/
			for( int s = newLength; (--s) >= sharedCharArrayLength; )
			Memories.byteMemory[(sharedByteArray + (s * 1))/*(sharedByteArray)[s];*/] = (byte)0;
		}
		
		this.sharedCharArrayLength = newLength;
	}
	public final void setLength(char newLength) {
		this.setLength((int)newLength);
	}
	public java.lang.String toString() {
		return IceteaStringSupport.toStringAndFree(this.i2j_toString());
	}
	public final String i2j_toString() {
		return new String( this.sharedCharArray, null, 0, this.sharedCharArrayLength);
	}
	public final void dispose() {
		if((--(Memories.byteMemory)[(this.sharedCharArray + (((Memories.intMemory)[((this.sharedCharArray - 4)/*length*/ >> 2)] - 1) * 1))/*(this.sharedCharArray)[this.sharedCharArray.length-1];*/]) <= 0) 
			IceteaRuntimeSupport.free(this.sharedCharArray);
		
	}
	public final String toStringAndFree() {
		String str = new String( this.sharedCharArray, null, this.sharedCharArrayLength, true);
		this.dispose();
		return str;
	}
	public final boolean equals(String str) {
		int length = str.length;
		if((str != null) && (length == this.sharedCharArrayLength)) {
			int lchars = this.sharedCharArray;/*byte[] lchars = this.sharedCharArray;*/
			
			while ((--length) >= 0)if(((byte)(Memories.byteMemory)[(str.chars + (length * 1))/*(str.chars)[length];*/]) != ((byte)(Memories.byteMemory)[(lchars + (length * 1))/*(lchars)[length];*/])) 
				return false;
			
			return true;
		}
		
		return false;
	}
	private final void growAndCopyIfShared(int minimumCapacity) {
		int sharedCharArray = this.sharedCharArray;/*byte[] sharedCharArray = this.sharedCharArray;*/
		int capacity = Memories.intMemory[((sharedCharArray - 4)/*length*/ >> 2)];
		if(capacity <= minimumCapacity) {
			capacity = capacity * 2;
			if(minimumCapacity >= capacity) 
				capacity = minimumCapacity + 16;
			else 
				capacity++;
			
			this.copyChars(capacity, this.sharedCharArrayLength);
		}
		else 
			if(this.isShared()) 
				this.copyChars(capacity, this.sharedCharArrayLength);
			
		
	}
	private final void copyChars(int capacity, int nbBytesToCopy) {
		int newArray = IceteaRuntimeSupport.allocateArrayNoInit(capacity, 1)/*new byte[capacity];*/;/*byte[] newArray = new byte[capacity];*/
		Array.copy8Bits(this.sharedCharArray, 0, newArray, 0, nbBytesToCopy);
		this.dispose();
		Memories.byteMemory[(newArray + ((capacity - 1) * 1))/*(newArray)[capacity-1];*/] = (byte)1;
		this.sharedCharArray = newArray;
	}
	private void shiftChars(int offset, int strLength) {
		int sharedCharArrayLength = this.sharedCharArrayLength;
		int srcArray = this.sharedCharArray;/*byte[] srcArray = this.sharedCharArray;*/
		int minimumCapacity = strLength + sharedCharArrayLength;
		int capacity = sharedCharArrayLength;
		boolean makeCopy;
		if(capacity <= minimumCapacity) {
			capacity = capacity * 2;
			if(minimumCapacity >= capacity) 
				capacity = minimumCapacity;
			
			makeCopy = true;
		}
		else 
			makeCopy = this.isShared();
		
		int newArray;/*byte[] newArray ;*/
		if(makeCopy) {
			newArray = IceteaRuntimeSupport.allocateArrayNoInit(capacity + 1, 1)/*new byte[capacity+1];*/;
			Array.copy8Bits(this.sharedCharArray, 0, newArray, 0, offset);
			Memories.byteMemory[(newArray + (capacity * 1))/*(newArray)[capacity];*/] = (byte)1;
		}
		else 
			newArray = srcArray;
		
		int nbCharsToShift = sharedCharArrayLength - offset;
		if(nbCharsToShift > 0) 
			Array.copy8Bits(srcArray, offset, newArray, offset + strLength, nbCharsToShift);
		
		if(makeCopy) 
			this.dispose();
		
		sharedCharArrayLength += strLength;
		this.sharedCharArrayLength = sharedCharArrayLength;
		this.sharedCharArray = newArray;
	}
	
}