package iceTea.lang;

import iceTea.lang.support.IceteaStringSupport;
import iceTea.lang.support.IceteaRuntimeSupport;
import iceTea.lang.StringBuilder;
import iceTea.lang.String;
import iceTea.lang.Object;
import iceTea.lang.Memories;
import iceTea.lang.Array;

public final class String extends Object{

	public int chars;/*public byte[] chars ;*/
	public int length;
	public static final int LongNumberMaxDigits = 21;
	public static final int IntNumberMaxDigits = 11;
	public static final int TO_UPPER_MASK = 223;
	public static final int TO_LOWER_MASK = 32;
	public static final byte LOWER_MAX = (byte)122;
	public static final byte LOWER_MIN = (byte)97;
	public static final byte UPPER_MAX = (byte)90;
	public static final byte UPPER_MIN = (byte)65;
	
	public String(int array, byte[] i2j_array, int len, boolean shared) {
		super();
		if(shared) {
			this.chars = array;
			this.length = len;
			(Memories.byteMemory)[(this.chars + (((Memories.intMemory)[((array - 4)/*length*/ >> 2)] - 1) * 1))/*(this.chars)[array.length-1];*/]++;
		}
		else {
			Array.copy8Bits(array, 0, this.chars = IceteaRuntimeSupport.allocateArrayNoInit(len + 1, 1)/*new byte[len+1];*/, 0, len);
			Memories.byteMemory[(this.chars + (len * 1))/*(this.chars)[len];*/] = (byte)1;
			this.length = len;
		}
		
	}
	public String() {
		super();
		this.chars = IceteaRuntimeSupport.allocateArray(1, 1)/*new byte[1];*/;
		Memories.byteMemory[(this.chars + (0 * 1))/*(this.chars)[0];*/] = (byte)1;
		this.length = 0;
	}
	public String(int bytes, byte[] i2j_bytes) {
		this(bytes, null, 0, Memories.intMemory[((bytes - 4)/*length*/ >> 2)]);
	}
	public String(int bytes, byte[] i2j_bytes, int off, int len) {
		super();
		this.chars = IceteaRuntimeSupport.allocateArrayNoInit(len + 1, 1)/*new byte[len+1];*/;
		this.length = len;
		Array.copy8Bits(bytes, off, this.chars, 0, len);
		Memories.byteMemory[(this.chars + (len * 1))/*(this.chars)[len];*/] = (byte)1;
	}
	public String(int bytes, byte[] i2j_bytes, char off, char len) {
		this(bytes, null, (int)off, ((int)len));
	}
	public String(String value) {
		super();
		int length = value.length;
		this.length = length;
		int chars = IceteaRuntimeSupport.allocateArray(length + 1, 1)/*new byte[length+1];*/;/*byte[] chars = new byte[length+1];*/
		Array.copy8Bits(value.chars, 0, chars, 0, length);
		Memories.byteMemory[(chars + (length * 1))/*(chars)[length];*/] = (byte)1;
		this.chars = chars;
	}
	public String(StringBuilder buffer) {
		this(buffer.sharedCharArray, null, 0, buffer.sharedCharArrayLength);
	}
	
	public boolean checkValidity() {
		return this.chars != 0;
	}
	public final byte charAt(int index) {
		return (byte)(Memories.byteMemory)[(this.chars + (index * 1))/*(this.chars)[index];*/];
	}
	public final byte charAt(char index) {
		return this.charAt((int)index);
	}
	public final int compareTo(String anotherString) {
		int array = this.chars;/*byte[] array = this.chars;*/
		int otherArray = anotherString.chars;/*byte[] otherArray = anotherString.chars;*/
		int length = this.length;
		int otherLength = anotherString.length;
		int stop = (length < otherLength)?length:otherLength;
		int i = -1;
		
		while ((++i) < stop){
			if(((byte)(Memories.byteMemory)[(array + (i * 1))/*(array)[i];*/]) != ((byte)(Memories.byteMemory)[(otherArray + (i * 1))/*(otherArray)[i];*/])) 
				return (int)((short)(((byte)(Memories.byteMemory)[(array + (i * 1))/*(array)[i];*/]) - ((byte)(Memories.byteMemory)[(otherArray + (i * 1))/*(otherArray)[i];*/])));
			
		}
		
		return length - otherLength;
	}
	public final String concat(String str) {
		int strLength = str.length;
		int thisLength = this.length;
		if(strLength == 0) 
			return this;
		
		int newLength = strLength + thisLength;
		int newArray = IceteaRuntimeSupport.allocateArrayNoInit(newLength + 1, 1)/*new byte[newLength+1];*/;/*byte[] newArray = new byte[newLength+1];*/
		Memories.byteMemory[(newArray + (newLength * 1))/*(newArray)[newLength];*/] = (byte)0;
		Array.copy8Bits(this.chars, 0, newArray, 0, thisLength);
		Array.copy8Bits(str.chars, 0, newArray, thisLength, strLength);
		return new String( newArray, null, newLength, true);
	}
	public final boolean endsWith(String suffix) {
		int otherLength = suffix.length;
		if(otherLength == 0) 
			return true;
		else 
			return this.regionMatches(false, this.length - otherLength, suffix, 0, otherLength);
		
	}
	public final boolean equals(String str) {
		if(str == null) 
			return false;
		
		if(this == str) 
			return true;
		
		int length = this.length;
		if(length != str.length) 
			return false;
		
		int array = this.chars;/*byte[] array = this.chars;*/
		int otherArray = str.chars;/*byte[] otherArray = str.chars;*/
		
		while ((--length) >= 0){
			if(((byte)(Memories.byteMemory)[(array + (length * 1))/*(array)[length];*/]) != ((byte)(Memories.byteMemory)[(otherArray + (length * 1))/*(otherArray)[length];*/])) 
				return false;
			
		}
		
		return true;
	}
	public final boolean equalsIgnoreCase(String anotherString) {
		if(anotherString == null) 
			return false;
		
		if(this == anotherString) 
			return true;
		
		int length = this.length;
		if(length != anotherString.length) 
			return false;
		
		int array = this.chars;/*byte[] array = this.chars;*/
		int otherArray = anotherString.chars;/*byte[] otherArray = anotherString.chars;*/
		char lowerCaseChar;
		
		while ((--length) >= 0){
			if(((byte)(Memories.byteMemory)[(array + (length * 1))/*(array)[length];*/]) != ((byte)(Memories.byteMemory)[(otherArray + (length * 1))/*(otherArray)[length];*/])) {
				if((((byte)(Memories.byteMemory)[(array + (length * 1))/*(array)[length];*/]) <= (byte)90) && (((byte)(Memories.byteMemory)[(array + (length * 1))/*(array)[length];*/]) >= (byte)65)) {
					lowerCaseChar = (char)(((byte)(Memories.byteMemory)[(array + (length * 1))/*(array)[length];*/]) | 32);
					if(lowerCaseChar != ((byte)(Memories.byteMemory)[(otherArray + (length * 1))/*(otherArray)[length];*/])) 
						return false;
					
				}
				else 
					if((((byte)(Memories.byteMemory)[(otherArray + (length * 1))/*(otherArray)[length];*/]) <= (byte)90) && (((byte)(Memories.byteMemory)[(otherArray + (length * 1))/*(otherArray)[length];*/]) >= (byte)65)) {
						lowerCaseChar = (char)(((byte)(Memories.byteMemory)[(otherArray + (length * 1))/*(otherArray)[length];*/]) | 32);
						if(((byte)(Memories.byteMemory)[(array + (length * 1))/*(array)[length];*/]) != lowerCaseChar) 
							return false;
						
					}
					else {
						return false;
					}
					
				
			}
			
		}
		
		return true;
	}
	public final void getChars__II_3BI(int srcBegin, int srcEnd, int dst, int dstBegin) {
		Array.copy8Bits(this.chars, srcBegin, dst, dstBegin, srcEnd - srcBegin);
	}
	public final void getChars__CC_3BC(char srcBegin, char srcEnd, int dst, char dstBegin) {
		this.getChars__II_3BI((int)srcBegin, (int)srcEnd, dst, (int)dstBegin);
	}
	public final int indexOf(byte ch) {
		return this.indexOf(ch, 0);
	}
	public final int indexOf(byte ch, int fromIndex) {
		if(fromIndex < 0) 
			fromIndex = 0;
		
		int length = this.length;
		int array = this.chars;/*byte[] array = this.chars;*/
		
		while (fromIndex < length){
			if(((byte)(Memories.byteMemory)[(array + (fromIndex * 1))/*(array)[fromIndex];*/]) == ch) 
				return fromIndex;
			
			fromIndex++;
		}
		
		return -1;
	}
	public final short indexOf(byte ch, char fromIndex) {
		return (short)this.indexOf(ch, (int)fromIndex);
	}
	public final int indexOf(String str) {
		return this.indexOf(str, 0);
	}
	public final int indexOf(String str, int fromIndex) {
		if(fromIndex < 0) 
			fromIndex = 0;
		
		int strLen = str.length;
		int thisLen = this.length;
		if(strLen == 0) 
			return (fromIndex >= thisLen)?thisLen:fromIndex;
		
		if((fromIndex >= thisLen) || ((thisLen - fromIndex) < strLen)) 
			return -1;
		
		int strChars = str.chars;/*byte[] strChars = str.chars;*/
		int thisChars = this.chars;/*byte[] thisChars = this.chars;*/
		int end = thisLen - strLen;
		byte firstChar = (byte)(Memories.byteMemory)[(strChars + (0 * 1))/*(strChars)[0];*/];
		
		while (true){
			
			while ((fromIndex <= end) && (((byte)(Memories.byteMemory)[(thisChars + (fromIndex * 1))/*(thisChars)[fromIndex];*/]) != firstChar))fromIndex++;
			if((fromIndex <= end) && (((byte)(Memories.byteMemory)[(thisChars + (fromIndex * 1))/*(thisChars)[fromIndex];*/]) == firstChar)) {
				boolean bContinue = false;
				for( int i = strLen; (--i) >= 0; )
				{
					if(((byte)(Memories.byteMemory)[(strChars + (i * 1))/*(strChars)[i];*/]) != ((byte)(Memories.byteMemory)[(thisChars + ((fromIndex + i) * 1))/*(thisChars)[fromIndex+i];*/])) {
						fromIndex++;
						bContinue = true;
					}
					
				}
				
				if(!bContinue) 
					return fromIndex;
				
			}
			else 
				return -1;
			
		}
		
	}
	public final short indexOf(String s, char fromIndex) {
		return (short)this.indexOf(s, (int)fromIndex);
	}
	public final int lastIndexOf(byte ch) {
		return this.lastIndexOf(ch, this.length - 1);
	}
	public final int lastIndexOf(byte ch, int fromIndex) {
		if(fromIndex >= this.length) 
			fromIndex = this.length - 1;
		
		int array = this.chars;/*byte[] array = this.chars;*/
		
		while (fromIndex >= 0){
			if(((byte)(Memories.byteMemory)[(array + (fromIndex * 1))/*(array)[fromIndex];*/]) == ch) 
				return fromIndex;
			
			fromIndex--;
		}
		
		return -1;
	}
	public final short lastIndexOf(byte ch, char fromIndex) {
		return (short)this.lastIndexOf(ch, (int)fromIndex);
	}
	public final int length() {
		return this.length;
	}
	public final boolean regionMatches(boolean ignoreCase, int toffset, String other, int ooffset, int len) {
		if((((toffset < 0) || (ooffset < 0)) || ((toffset + len) > this.length)) || ((ooffset + len) > other.length)) 
			return false;
		
		if(this == other) 
			return true;
		
		int array = this.chars;/*byte[] array = this.chars;*/
		int otherArray = other.chars;/*byte[] otherArray = other.chars;*/
		int tIndex = toffset + len;
		int oIndex = ooffset + len;
		if(ignoreCase) {
			byte lowerCaseChar;
			
			while ((--tIndex) >= toffset){
				if(((byte)(Memories.byteMemory)[(array + (tIndex * 1))/*(array)[tIndex];*/]) != ((byte)(Memories.byteMemory)[(otherArray + ((--oIndex) * 1))/*(otherArray)[--oIndex];*/])) {
					if((((byte)(Memories.byteMemory)[(array + (tIndex * 1))/*(array)[tIndex];*/]) <= (byte)90) && (((byte)(Memories.byteMemory)[(array + (tIndex * 1))/*(array)[tIndex];*/]) >= (byte)65)) {
						lowerCaseChar = (byte)(((byte)(Memories.byteMemory)[(array + (tIndex * 1))/*(array)[tIndex];*/]) | 32);
						if(lowerCaseChar != ((byte)(Memories.byteMemory)[(otherArray + (oIndex * 1))/*(otherArray)[oIndex];*/])) 
							return false;
						
					}
					else 
						if((((byte)(Memories.byteMemory)[(otherArray + (oIndex * 1))/*(otherArray)[oIndex];*/]) <= (byte)90) && (((byte)(Memories.byteMemory)[(otherArray + (oIndex * 1))/*(otherArray)[oIndex];*/]) >= (byte)65)) {
							lowerCaseChar = (byte)(((byte)(Memories.byteMemory)[(otherArray + (oIndex * 1))/*(otherArray)[oIndex];*/]) | 32);
							if(lowerCaseChar != ((byte)(Memories.byteMemory)[(array + (tIndex * 1))/*(array)[tIndex];*/])) 
								return false;
							
						}
						else {
							return false;
						}
						
					
				}
				
			}
			
		}
		else {
			
			while ((--tIndex) >= toffset){
				if(((byte)(Memories.byteMemory)[(array + (tIndex * 1))/*(array)[tIndex];*/]) != ((byte)(Memories.byteMemory)[(otherArray + ((--oIndex) * 1))/*(otherArray)[--oIndex];*/])) 
					return false;
				
			}
			
		}
		
		return true;
	}
	public final boolean regionMatches(boolean ignoreCase, char toffset, String other, char ooffset, char len) {
		return this.regionMatches(ignoreCase, (int)toffset, other, (int)ooffset, (int)len);
	}
	public final String replace(byte oldChar, byte newChar) {
		int len = this.length;
		int chars = this.chars;/*byte[] chars = this.chars;*/
		int newArray = IceteaRuntimeSupport.allocateArrayNoInit(len + 1, 1)/*new byte[len+1];*/;/*byte[] newArray = new byte[len+1];*/
		boolean charFound = false;
		for( int i = len; (--i) >= 0; )
		{
			if(((byte)(Memories.byteMemory)[(chars + (i * 1))/*(chars)[i];*/]) == oldChar) {
				charFound = true;
				Memories.byteMemory[(newArray + (i * 1))/*(newArray)[i];*/] = newChar;
			}
			else {
				Memories.byteMemory[(newArray + (i * 1))/*(newArray)[i];*/] = (byte)(Memories.byteMemory)[(chars + (i * 1))/*(chars)[i];*/];
			}
			
		}
		
		if(charFound) {
			Memories.byteMemory[(newArray + (len * 1))/*(newArray)[len];*/] = (byte)0;
			return new String( newArray, null, len, true);
		}
		else {
			IceteaRuntimeSupport.free(newArray);
			return this;
		}
		
	}
	public final boolean startsWith(String prefix) {
		return this.regionMatches(false, 0, prefix, 0, prefix.length);
	}
	public final boolean startsWith(String prefix, int toffset) {
		return this.regionMatches(false, toffset, prefix, 0, prefix.length);
	}
	public final boolean startsWith(String prefix, char toffset) {
		return this.startsWith(prefix, (int)toffset);
	}
	public final String substring(int beginIndex) {
		return new String( this.chars, null, beginIndex, this.length - beginIndex);
	}
	public final String substring(char beginIndex) {
		return this.substring((int)beginIndex);
	}
	public final String substring(int beginIndex, int endIndex) {
		return new String( this.chars, null, beginIndex, endIndex - beginIndex);
	}
	public final String substring(char beginIndex, char endIndex) {
		return this.substring((int)beginIndex, (int)endIndex);
	}
	public final int toByteArray() {
		int length = this.length;
		int newArray = IceteaRuntimeSupport.allocateArrayNoInit(length, 1)/*new byte[length];*/;/*byte[] newArray = new byte[length];*/
		Array.copy8Bits(this.chars, 0, newArray, 0, length);
		return newArray;
	}
	public final String toLowerCase() {
		int index = this.length;
		int newArray = IceteaRuntimeSupport.allocateArrayNoInit(index + 1, 1)/*new byte[index+1];*/;/*byte[] newArray = new byte[index+1];*/
		Memories.byteMemory[(newArray + (index * 1))/*(newArray)[index];*/] = (byte)0;
		int chars = this.chars;/*byte[] chars = this.chars;*/
		
		while ((--index) >= 0){
			if((((byte)(Memories.byteMemory)[(chars + (index * 1))/*(chars)[index];*/]) >= (byte)65) && (((byte)(Memories.byteMemory)[(chars + (index * 1))/*(chars)[index];*/]) <= (byte)90)) 
				Memories.byteMemory[(newArray + (index * 1))/*(newArray)[index];*/] = (byte)(((byte)(Memories.byteMemory)[(chars + (index * 1))/*(chars)[index];*/]) | 32);
			else 
				Memories.byteMemory[(newArray + (index * 1))/*(newArray)[index];*/] = (byte)(Memories.byteMemory)[(chars + (index * 1))/*(chars)[index];*/];
			
		}
		
		return new String( newArray, null, this.length, true);
	}
	public void dispose() {
		if((--(Memories.byteMemory)[(this.chars + (((Memories.intMemory)[((this.chars - 4)/*length*/ >> 2)] - 1) * 1))/*(this.chars)[this.chars.length-1];*/]) == 0) {
			IceteaRuntimeSupport.free(this.chars);
			this.chars = 0;
		}
		
	}
	public java.lang.String toString() {
		return IceteaStringSupport.toString(this);
	}
	public final String i2j_toString() {
		return this;
	}
	public final String toUpperCase() {
		int index = this.length;
		int newArray = IceteaRuntimeSupport.allocateArrayNoInit(index + 1, 1)/*new byte[index+1];*/;/*byte[] newArray = new byte[index+1];*/
		Memories.byteMemory[(newArray + (index * 1))/*(newArray)[index];*/] = (byte)0;
		int chars = this.chars;/*byte[] chars = this.chars;*/
		
		while ((--index) >= 0){
			if((((byte)(Memories.byteMemory)[(chars + (index * 1))/*(chars)[index];*/]) >= (byte)97) && (((byte)(Memories.byteMemory)[(chars + (index * 1))/*(chars)[index];*/]) <= (byte)122)) 
				Memories.byteMemory[(newArray + (index * 1))/*(newArray)[index];*/] = (byte)(((byte)(Memories.byteMemory)[(chars + (index * 1))/*(chars)[index];*/]) & 223);
			else 
				Memories.byteMemory[(newArray + (index * 1))/*(newArray)[index];*/] = (byte)(Memories.byteMemory)[(chars + (index * 1))/*(chars)[index];*/];
			
		}
		
		return new String( newArray, null, this.length, true);
	}
	public final String trim() {
		if(this.length > 0) {
			int i = 0;
			int j = this.length - 1;
			int array = this.chars;/*byte[] array = this.chars;*/
			
			while ((((byte)(Memories.byteMemory)[(array + (i * 1))/*(array)[i];*/]) <= (byte)32) && (i < j))++i;
			
			while ((j >= i) && (((byte)(Memories.byteMemory)[(array + (j * 1))/*(array)[j];*/]) <= (byte)32))--j;
			if((i != 0) || (j != (this.length - 1))) {
				if((i == j) && (((byte)(Memories.byteMemory)[(array + (i * 1))/*(array)[i];*/]) <= (byte)32)) 
					return new String();
				else 
					return new String( array, null, i, (j - i) + 1);
				
			}
			
		}
		
		return this;
	}
	public static final String valueOf(boolean b) {
		int array;/*byte[] array ;*/
		if(b) {
			array = IceteaRuntimeSupport.allocateArray(new byte[] { (byte)116, (byte)114, (byte)117, (byte)101, (byte)0});
			return new String( array, null, 4, true);
		}
		else {
			array = IceteaRuntimeSupport.allocateArray(new byte[] { (byte)102, (byte)97, (byte)108, (byte)115, (byte)101, (byte)0});
			return new String( array, null, 5, true);
		}
		
	}
	public static final String valueOf(char c) {
		int array = IceteaRuntimeSupport.allocateArray(new byte[] { (byte)c, (byte)0});/*byte[] array = new byte[]{((byte)(c)),((byte)(0))};*/
		return new String( array, null, 1, true);
	}
	public static final String valueOfAsciiCharacter(byte b) {
		int array = IceteaRuntimeSupport.allocateArray(new byte[] { b, (byte)0});/*byte[] array = new byte[]{b,((byte)(0))};*/
		return new String( array, null, 1, true);
	}
	public static final String valueOf(byte b) {
		return String.valueOf((int)b);
	}
	public static final String valueOfCharValue(char c) {
		return String.valueOf((int)c);
	}
	public static final String valueOf(short s) {
		return String.valueOf((int)s);
	}
	public static final String valueOf(int i) {
		int array = IceteaRuntimeSupport.allocateArrayNoInit(12, 1)/*new byte[12];*/;/*byte[] array = new byte[12];*/
		Memories.byteMemory[(array + (11 * 1))/*(array)[iceTea.lang.String.IntNumberMaxDigits];*/] = (byte)0;
		int length = String.intToByteArray(array, i, 0);
		return new String( array, null, length, true);
	}
	public static final String valueOf(long l) {
		int array = IceteaRuntimeSupport.allocateArrayNoInit(22, 1)/*new byte[22];*/;/*byte[] array = new byte[22];*/
		Memories.byteMemory[(array + (21 * 1))/*(array)[iceTea.lang.String.LongNumberMaxDigits];*/] = (byte)0;
		int length = String.longToByteArray(array, l, 0);
		return new String( array, null, length, true);
	}
	private static byte characterFromDigit(int digit) {
		if(digit < 0) 
			digit = -digit;
		
		if((digit > 0) && (digit <= 9)) 
			return (byte)(digit + '0');
		else 
			return (byte)48;
		
	}
	public static int intToByteArray(int array, int i, int offset) {
		if(i == 0) {
			Memories.byteMemory[(array + ((offset++) * 1))/*(array)[offset++];*/] = (byte)48;
			return offset;
		}
		
		if(i < 0) {
			Memories.byteMemory[(array + ((offset++) * 1))/*(array)[offset++];*/] = (byte)45;
		}
		
		int div = 1000000000;
		boolean isPrinting = false;
		
		while (div > 0){
			int digit = i / div;
			i = i % div;
			if(digit == 0) {
				if(isPrinting) 
					Memories.byteMemory[(array + ((offset++) * 1))/*(array)[offset++];*/] = (byte)48;
				
			}
			else {
				isPrinting = true;
				Memories.byteMemory[(array + ((offset++) * 1))/*(array)[offset++];*/] = String.characterFromDigit(digit);
			}
			
			div = div / 10;
		}
		
		return offset;
	}
	public static int longToByteArray(int array, long l, int offset) {
		if(l == 0l) {
			Memories.byteMemory[(array + ((offset++) * 1))/*(array)[offset++];*/] = (byte)48;
			return offset;
		}
		
		if(l < 0l) {
			Memories.byteMemory[(array + ((offset++) * 1))/*(array)[offset++];*/] = (byte)45;
		}
		
		long div = 1000000000000000000l;
		boolean isPrinting = false;
		
		while (div > 0l){
			int digit = (int)(l / div);
			l = l % div;
			if(digit == 0) {
				if(isPrinting) 
					Memories.byteMemory[(array + ((offset++) * 1))/*(array)[offset++];*/] = (byte)48;
				
			}
			else {
				isPrinting = true;
				Memories.byteMemory[(array + ((offset++) * 1))/*(array)[offset++];*/] = String.characterFromDigit(digit);
			}
			
			div = div / 10l;
		}
		
		return offset;
	}
	public static String valueOf(Object obj) {
		int array = (int)IceteaRuntimeSupport.allocateArrayNoInit(13, 1)/*new byte[13];*/;/*byte[] array = ((byte[])(new byte[13]));*/
		Memories.byteMemory[(array + (0 * 1))/*(array)[0];*/] = (byte)64;
		int length = String.intToByteArray(array, obj.hashCode(), 1);
		Memories.byteMemory[(array + (length * 1))/*(array)[length];*/] = (byte)0;
		return new String( array, null, 0, length);
	}
	
}