/*
 * Java
 *
 * Copyright 2009-2013 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package iceTea.lang;


public class FloatI2jNatives {

	/**
	 * Returns the bit representation of a single-float value. The result is a
	 * representation of the floating-point argument according to the IEEE 754
	 * floating-point "single precision" bit layout.
	 * 
	 * Bit 31 (the bit that is selected by the mask 0x80000000) represents the
	 * sign of the floating-point number. Bits 30-23 (the bits that are
	 * selected by the mask 0x7f800000) represent the exponent. Bits 22-0 (the
	 * bits that are selected by the mask 0x007fffff) represent the significand
	 * (sometimes called the mantissa) of the floating-point number.
	 * 
	 * If the argument is positive infinity, the result is 0x7f800000.
	 * If the argument is negative infinity, the result is 0xff800000.
	 * If the argument is NaN, the result is 0x7fc00000.
	 * 
	 * In all cases, the result is an integer that, when given to the
	 * intBitsToFloat(int) method, will produce a floating-point value equal to
	 * the argument to floatToIntBits.
	 */
	public static int floatToIntBits(float value) {
		return java.lang.Float.floatToIntBits(value);
	}

	  /** Returns the single-float corresponding to a given bit representation.
     * The argument is considered to be a representation of a floating-point
     * value according to the IEEE 754 floating-point "single precision"
     * bit layout.
     * 
     * If the argument is 0x7f800000, the result is positive infinity.
     * If the argument is 0xff800000, the result is negative infinity.
     * If the argument is any value in the range 0x7f800001 through 0x7fffffff
     *    or in the range 0xff800001 through 0xffffffff, the result is NaN.
     *    All IEEE 754 NaN values of type float are, in effect, lumped together
     *    by the Java programming language into a single float value called NaN.
     * 
     * In all other cases, let s, e, and m be three values that can be computed
     * from the argument:
     * 
     *     int s = ((bits >> 31) == 0) ? 1 : -1;
     *     int e = ((bits >> 23) & 0xff);
     *     int m = (e == 0) ?
     *                     (bits & 0x7fffff) << 1 :
     *                     (bits & 0x7fffff) | 0x800000;
     * 
     * Then the floating-point result equals the value of the mathematical
     * expression s?m?2e-150.
     */
	public static float intBitsToFloat(int bits) {
		return java.lang.Float.intBitsToFloat(bits);
	}

	public static final boolean isNaNIntern(float v)
	{
		return Float.isNaN(v);
	}
}
