package iceTea.lang;

import iceTea.lang.support.IceteaStringSupport;
import iceTea.lang.support.IceteaRuntimeSupport;
import iceTea.lang.String;
import iceTea.lang.Object;
import iceTea.lang.Memories;
import iceTea.lang.FloatI2jNatives;
import iceTea.lang.Float;
import iceTea.lang.FPUtil;
import iceTea.lang.Data;

public class Float extends Object{

	private static final int IMPLIED_ONE = 8388608;
	private static final int NEGATIVE_ZERO = -2147483648;
	private static final int ZERO = 0;
	private static final int IMPLICIT_BIT = 8388608;
	private static final int FRAC_MASK = 8388607;
	private static final int EXP_OFFSET = 23;
	private static final int EXP_MASK = 2139095040;
	private static final int SIGN_MASK = -2147483648;
	public static final String FLOAT_F10 = IceteaStringSupport.internString("FLOAT_F10");
	public static final String FLOAT_E10 = IceteaStringSupport.internString("FLOAT_E10");
	public static final String FLOAT_F2 = IceteaStringSupport.internString("FLOAT_F2");
	public static final String FLOAT_E2 = IceteaStringSupport.internString("FLOAT_E2");
	public static final char EXPOSANT_CHAR_2 = 'e';
	public static final char EXPOSANT_CHAR_1 = 'E';
	public static final int POSITIVE_INFINITY_INT = 2139095040;
	public static final float POSITIVE_INFINITY = 1f/0f;
	public static final int NEGATIVE_INFINITY_INT = -8388608;
	public static final float NEGATIVE_INFINITY = -1f/0f;
	public static final int NaN_INT = 2143289344;
	public static final float NaN = 0f/0f;
	public static final float MIN_VALUE = 1.4E-45f;
	public static final float MAX_VALUE = 3.4028235E38f;
	
	public Float() {
		super();
	}
	
	public static final int floatToIntBits(float value) {
		return FloatI2jNatives.floatToIntBits(value);
	}
	public static final float intBitsToFloat(int bits) {
		return FloatI2jNatives.intBitsToFloat(bits);
	}
	public static boolean isInfinite(float v) {
		return (v == 1f/0f) || (v == -1f/0f);
	}
	private static final boolean isNaNIntern(float v) {
		return FloatI2jNatives.isNaNIntern(v);
	}
	public static final boolean isNaN(float v) {
		return Float.isNaNIntern(v);
	}
	public static final float parseFloat(String s) {
		String s2 = s.trim();
		int bytes = s2.toByteArray();/*byte[] bytes = s2.toByteArray();*/
		float result = Float.parseFloat___3BII(bytes, 0, Memories.intMemory[((bytes - 4)/*length*/ >> 2)]);
		IceteaRuntimeSupport.free(bytes);
		if(s2 != s) 
			s2.dispose();
		
		return result;
	}
	public static final float parseFloat___3BCC(int bytes, char start, char length) {
		return Float.parseFloat___3BII(bytes, (int)start, (int)length);
	}
	public static final float parseFloat___3BII(int bytes, int offset, int length) {
		if(length == 0) 
			return 0f/0f;
		
		int stop = offset + length;
		boolean neg = false;
		
		switch( (byte)(Memories.byteMemory)[(bytes + (0 * 1))/*(bytes)[0];*/]){
				
			case (byte)45 : 
				neg = true;
				
			case (byte)43 : 
				++offset;
		}
		if(offset == stop) 
			return 0f/0f;
		
		byte current = (byte)(Memories.byteMemory)[(bytes + (offset * 1))/*(bytes)[offset];*/];
		if(current == (byte)73) {
			if(((((((((stop - offset) != 8) || (((byte)(Memories.byteMemory)[(bytes + ((offset + 1) * 1))/*(bytes)[offset+1];*/]) != 'n')) || (((byte)(Memories.byteMemory)[(bytes + ((offset + 2) * 1))/*(bytes)[offset+2];*/]) != 'f')) || (((byte)(Memories.byteMemory)[(bytes + ((offset + 3) * 1))/*(bytes)[offset+3];*/]) != 'i')) || (((byte)(Memories.byteMemory)[(bytes + ((offset + 4) * 1))/*(bytes)[offset+4];*/]) != 'n')) || (((byte)(Memories.byteMemory)[(bytes + ((offset + 5) * 1))/*(bytes)[offset+5];*/]) != 'i')) || (((byte)(Memories.byteMemory)[(bytes + ((offset + 6) * 1))/*(bytes)[offset+6];*/]) != 't')) || (((byte)(Memories.byteMemory)[(bytes + ((offset + 7) * 1))/*(bytes)[offset+7];*/]) != 'y')) 
				return 0f/0f;
			
			if(neg) 
				return -1f/0f;
			
			return 1f/0f;
		}
		
		if(((current < '0') || (current > '9')) && (current != '.')) 
			return 0f/0f;
		
		int e = 0;
		int f = 0;
		byte lastChar = (byte)(Memories.byteMemory)[(bytes + ((stop - 1) * 1))/*(bytes)[stop-1];*/];
		if((lastChar == 'f') || (lastChar == 'F')) {
			stop--;
			lastChar = (byte)(Memories.byteMemory)[(bytes + ((stop - 1) * 1))/*(bytes)[stop-1];*/];
		}
		
		if((lastChar < '0') || (lastChar > '9')) 
			return 0f/0f;
		
		int fMaxValue = 214748355;
		
		while ((((offset < stop) && (((byte)(Memories.byteMemory)[(bytes + (offset * 1))/*(bytes)[offset];*/]) != (byte)46)) && (((byte)(Memories.byteMemory)[(bytes + (offset * 1))/*(bytes)[offset];*/]) != 'E')) && (((byte)(Memories.byteMemory)[(bytes + (offset * 1))/*(bytes)[offset];*/]) != 'e')){
			current = (byte)(Memories.byteMemory)[(bytes + (offset * 1))/*(bytes)[offset];*/];
			if((current >= '0') && (current <= '9')) {
				if(f < fMaxValue) {
					f *= 10;
					f += current - '0';
				}
				else 
					e++;
				
			}
			else 
				return 0f/0f;
			
			offset++;
		}
		
		if((offset < stop) && (((byte)(Memories.byteMemory)[(bytes + (offset * 1))/*(bytes)[offset];*/]) == (byte)46)) {
			++offset;
			
			while (((offset < stop) && (((byte)(Memories.byteMemory)[(bytes + (offset * 1))/*(bytes)[offset];*/]) != 'E')) && (((byte)(Memories.byteMemory)[(bytes + (offset * 1))/*(bytes)[offset];*/]) != 'e')){
				current = (byte)(Memories.byteMemory)[(bytes + (offset * 1))/*(bytes)[offset];*/];
				if((current >= '0') && (current <= '9')) {
					if(f < fMaxValue) {
						f *= 10;
						f += current - '0';
						e--;
					}
					
				}
				else 
					return 0f/0f;
				
				offset++;
			}
			
		}
		
		if((offset < stop) && ((((byte)(Memories.byteMemory)[(bytes + (offset * 1))/*(bytes)[offset];*/]) == 'E') || (((byte)(Memories.byteMemory)[(bytes + (offset * 1))/*(bytes)[offset];*/]) == 'e'))) {
			current = (byte)(Memories.byteMemory)[(bytes + ((++offset) * 1))/*(bytes)[++offset];*/];
			boolean negE = false;
			
			switch( current){
					
				case (byte)45 : 
					negE = true;
					
				case (byte)43 : 
					++offset;
			}
			int readE = 0;
			
			while (offset < stop){
				current = (byte)(Memories.byteMemory)[(bytes + (offset * 1))/*(bytes)[offset];*/];
				if(readE < 214748355) {
					if((current >= '0') && (current <= '9')) {
						readE *= 10;
						readE += current - '0';
					}
					else 
						return 0f/0f;
					
				}
				
				offset++;
			}
			
			if(readE >= 214748355) {
				if((!negE) && (f != 0)) 
					return neg?-1f/0f:1f/0f;
				
				return Float.intBitsToFloat(neg?-2147483648:0);
			}
			
			if(negE) 
				readE *= -1;
			
			e += readE;
		}
		
		if(offset != stop) 
			return 0f/0f;
		
		return Float.intBitsToFloat(Float.getFloatBits(neg, f, e));
	}
	private static int getFloatBits(boolean neg, int f10, int e10) {
		long f2 = (long)f10;
		
		while ((f2 > 0l) && (f2 < 214748364l)){
			f2 *= 10l;
			e10--;
		}
		
		e10 += 54;
		if((e10 < 0) || (f10 == 0)) {
			return neg?-2147483648:0;
		}
		else 
			if(e10 > 92) {
				return neg?-8388608:2139095040;
			}
			
		
		boolean x10 = (e10 & 1) != 0;
		int eId = e10 >> 1;
		int E2 = (int)Data.dataArrayAt(IceteaStringSupport.internString("FLOAT_E2"));/*int[ro] E2 = ((int[ro])(iceTea.lang.Data.dataArrayAt(iceTea.lang.Float.FLOAT_E2)));*/
		int F2 = (int)Data.dataArrayAt(IceteaStringSupport.internString("FLOAT_F2"));/*int[ro] F2 = ((int[ro])(iceTea.lang.Data.dataArrayAt(iceTea.lang.Float.FLOAT_F2)));*/
		int e2 = Memories.intMemory[((E2 + (eId * 4))/*(E2)[eId];*/ >> 2)];
		e2 -= 32;
		f2 *= ((long)(Memories.intMemory)[((F2 + (eId * 4))/*(F2)[eId];*/ >> 2)]) & 4294967295l;
		if(x10) {
			f2 += f2 >>> 2;
			e2 += 3;
		}
		
		int shift = 32 - FPUtil.nbZeros(f2);
		e2 += shift;
		if(shift > 0) 
			f2 = (long)FPUtil.shiftRightWithRounding(f2, shift);
		else 
			f2 <<= -shift;
		
		int resultMask;
		if(e2 < -157) {
			resultMask = FPUtil.shiftRightWithRounding((int)f2, -149 - e2);
			if((resultMask == 0) && (f2 != 0l)) 
				resultMask = 1;
			
		}
		else {
			f2 = (long)FPUtil.shiftRightWithRounding((int)f2, 8);
			if(f2 == 16777216l) {
				f2 = 8388608l;
				e2++;
			}
			
			if(e2 > 98) {
				return neg?-8388608:2139095040;
			}
			
			resultMask = ((int)f2) ^ 8388608;
			resultMask |= (e2 + 158) << 23;
		}
		
		if(neg) 
			resultMask |= -2147483648;
		
		return resultMask;
	}
	private static boolean IsNegative(int f) {
		return (f & -2147483648) != 0;
	}
	private static int Exponent(int f) {
		return (f & 2139095040) >>> 23;
	}
	private static int Fraction(int f) {
		return f & 8388607;
	}
	public static String toString(float af) {
		int v = Float.floatToIntBits(af);
		boolean isNeg = Float.IsNegative(v);
		int e = Float.Exponent(v);
		int f = Float.Fraction(v);
		if(e == 255) {
			if(f != 0) 
				return new String( IceteaStringSupport.internString("NaN"));
			
			return isNeg?new String( IceteaStringSupport.internString("-Infinity")):new String( IceteaStringSupport.internString("Infinity"));
		}
		
		if(e == 0) {
			if(f == 0) 
				return isNeg?new String( IceteaStringSupport.internString("-0.0")):new String( IceteaStringSupport.internString("0.0"));
			
			f <<= 1;
		}
		else {
			f |= 8388608;
		}
		
		int initialf = f;
		int fShift = e & 7;
		f <<= fShift;
		int eId = e >>> 3;
		int E10 = (int)Data.dataArrayAt(IceteaStringSupport.internString("FLOAT_E10"));/*byte[ro] E10 = ((byte[ro])(iceTea.lang.Data.dataArrayAt(iceTea.lang.Float.FLOAT_E10)));*/
		int F10 = (int)Data.dataArrayAt(IceteaStringSupport.internString("FLOAT_F10"));/*int[ro] F10 = ((int[ro])(iceTea.lang.Data.dataArrayAt(iceTea.lang.Float.FLOAT_F10)));*/
		int e10 = (int)((byte)(Memories.byteMemory)[(E10 + (eId * 1))/*(E10)[eId];*/]);
		
		while (f < 214748364){
			f *= 10;
			e10--;
		}
		
		long f10l = ((long)f) * (((long)(Memories.intMemory)[((F10 + (eId * 4))/*(F10)[eId];*/ >> 2)]) & 4294967295l);
		int f10 = (int)(f10l >>> 32);
		if((f10l & -2147483648l) != 0l) 
			f10++;
		
		if(Float.getFloatBits(isNeg, f10, e10) == v) {
			
			while (true){
				int f10tmp = f10 / 10;
				int e10tmp = e10 + 1;
				boolean rounding = (f10 % 10) >= 5;
				if(rounding) 
					f10tmp++;
				
				if(Float.getFloatBits(isNeg, f10tmp, e10tmp) != v) {
					if(rounding) 
						f10tmp--;
					
					if(Float.getFloatBits(isNeg, f10tmp, e10tmp) != v) 
						break;
					
				}
				
				f10 = f10tmp;
				e10 = e10tmp;
			}
			
		}
		else {
			long fplusl = (((long)initialf) + 1l) << fShift;
			int nbMultiply = ((byte)(Memories.byteMemory)[(E10 + (eId * 1))/*(E10)[eId];*/]) - e10;
			
			while ((fplusl < 214748364l) && ((--nbMultiply) >= 0)){
				fplusl *= 10l;
			}
			
			fplusl *= ((long)(Memories.intMemory)[((F10 + (eId * 4))/*(F10)[eId];*/ >> 2)]) & 4294967295l;
			int fplus = (int)(fplusl >>> 32);
			if((fplusl & -2147483648l) != 0l) 
				fplus++;
			
			
			while ((--nbMultiply) >= 0){
				boolean roundup = (f10 % 10) >= 5;
				f10 /= 10;
				e10++;
				if(roundup) 
					f10++;
				
			}
			
			int diffplus = fplus - f10;
			
			while (diffplus > 10){
				boolean f10Roundup = (f10 % 10) >= 5;
				f10 /= 10;
				if(f10Roundup) 
					f10++;
				
				boolean fplusRoundup = (fplus % 10) >= 5;
				fplus /= 10;
				if(fplusRoundup) 
					fplus++;
				
				diffplus = fplus - f10;
				e10++;
			}
			
			int valueRange = ((int)diffplus) >>> 1;
			for( int i = -valueRange; i <= valueRange; i++)
			{
				if(((f10 + i) % 10) == 0) {
					f10 += i;
					break;
				}
				
			}
			
		}
		
		return FPUtil.toString10(isNeg, (long)f10, e10, -3, 7);
	}
	
}