package iceTea.lang;

import icetea.os.Thread;
import iceTea.lang.support.IceteaRuntimeSupport;
import iceTea.lang.String;
import iceTea.lang.Object;
import iceTea.lang.Memories;
import iceTea.lang.Float;
import iceTea.lang.FPUtil;
import iceTea.lang.Double;
import iceTea.lang.Array;

public class FPUtil extends Object{

	public FPUtil() {
		super();
	}
	
	static int nbZeros(long n) {
		if(n == 0l) 
			return 64;
		
		long mask = -9223372036854775808l;
		int count = 0;
		
		while ((n & mask) == 0l){
			count++;
			mask >>>= 1;
		}
		
		return count;
	}
	static int shiftRightWithRounding(int n, int shift) {
		if(shift > 32) 
			return 0;
		
		boolean rounding = (n & (1 << (shift - 1))) != 0;
		if(shift == 32) 
			return rounding?1:0;
		
		n >>>= shift;
		return rounding?n + 1:n;
	}
	static long shiftRightWithRounding(long n, int shift) {
		if(shift > 64) 
			return 0l;
		
		boolean rounding = (n & (1l << (shift - 1))) != 0l;
		if(shift == 64) 
			return rounding?1l:0l;
		
		n >>>= shift;
		return rounding?n + 1l:n;
	}
	static String toString10(boolean neg, long f10, int e10, int minExp, int maxExp) {
		int i2j_allocaPtr = IceteaRuntimeSupport.currentAllocaPtr();
		
		while ((f10 != 0l) && ((f10 % 10l) == 0l)){
			f10 /= 10l;
			e10++;
		}
		
		int f10Bytes = FPUtil.LongToString10(f10);/*byte[] f10Bytes = iceTea.lang.FPUtil.LongToString10(f10);*/
		int f10Length = Memories.intMemory[((f10Bytes - 4)/*length*/ >> 2)];
		e10 += f10Length - 1;
		int result;/*byte[] result ;*/
		int resultSize;
		if((e10 < minExp) || (e10 >= maxExp)) {
			resultSize = f10Length + 2;
			if(neg) 
				resultSize++;
			
			int e10Bytes = FPUtil.IntToString10(e10);/*byte[] e10Bytes = iceTea.lang.FPUtil.IntToString10(e10);*/
			resultSize += Memories.intMemory[((e10Bytes - 4)/*length*/ >> 2)];
			if(f10Length == 1) 
				resultSize++;
			
			result = Thread.currentThread().allocateArrayNoInit(resultSize, 1)/*new byte[resultSize];*/;
			int f10Index = -1;
			int resultIndex = -1;
			if(neg) 
				Memories.byteMemory[(result + ((++resultIndex) * 1))/*(result)[++resultIndex];*/] = (byte)45;
			
			Memories.byteMemory[(result + ((++resultIndex) * 1))/*(result)[++resultIndex];*/] = (byte)(Memories.byteMemory)[(f10Bytes + ((++f10Index) * 1))/*(f10Bytes)[++f10Index];*/];
			Memories.byteMemory[(result + ((++resultIndex) * 1))/*(result)[++resultIndex];*/] = (byte)46;
			if(f10Length == 1) 
				Memories.byteMemory[(result + ((++resultIndex) * 1))/*(result)[++resultIndex];*/] = (byte)48;
			else {
				Array.copy8Bits(f10Bytes, f10Index + 1, result, resultIndex + 1, f10Length - 1);
				resultIndex += f10Length - 1;
			}
			
			Memories.byteMemory[(result + ((++resultIndex) * 1))/*(result)[++resultIndex];*/] = (byte)69;
			Array.copy8Bits(e10Bytes, 0, result, resultIndex + 1, Memories.intMemory[((e10Bytes - 4)/*length*/ >> 2)]);
			IceteaRuntimeSupport.free(e10Bytes);
		}
		else {
			if(e10 < 0) 
				resultSize = (f10Length + 1) - e10;
			else {
				resultSize = (f10Length <= (e10 + 1))?e10 + 3:f10Length + 1;
			}
			
			if(neg) 
				resultSize++;
			
			result = Thread.currentThread().allocateArrayNoInit(resultSize, 1)/*new byte[resultSize];*/;
			int resultIndex = -1;
			if(neg) 
				Memories.byteMemory[(result + ((++resultIndex) * 1))/*(result)[++resultIndex];*/] = (byte)45;
			
			if(e10 < 0) {
				Memories.byteMemory[(result + ((++resultIndex) * 1))/*(result)[++resultIndex];*/] = (byte)48;
				Memories.byteMemory[(result + ((++resultIndex) * 1))/*(result)[++resultIndex];*/] = (byte)46;
				e10++;
				
				while (e10 < 0){
					Memories.byteMemory[(result + ((++resultIndex) * 1))/*(result)[++resultIndex];*/] = (byte)48;
					e10++;
				}
				
				Array.copy8Bits(f10Bytes, 0, result, resultIndex + 1, f10Length);
			}
			else {
				for( int i = -1; (++i) < f10Length; )
				{
					Memories.byteMemory[(result + ((++resultIndex) * 1))/*(result)[++resultIndex];*/] = (byte)(Memories.byteMemory)[(f10Bytes + (i * 1))/*(f10Bytes)[i];*/];
					if(e10 == 0) {
						Memories.byteMemory[(result + ((++resultIndex) * 1))/*(result)[++resultIndex];*/] = (byte)46;
					}
					
					e10--;
				}
				
				if(e10 == -1) {
					Memories.byteMemory[(result + ((++resultIndex) * 1))/*(result)[++resultIndex];*/] = (byte)48;
				}
				
				if(e10 >= 0) {
					
					while (e10 >= 0){
						Memories.byteMemory[(result + ((++resultIndex) * 1))/*(result)[++resultIndex];*/] = (byte)48;
						e10--;
					}
					
					Memories.byteMemory[(result + ((++resultIndex) * 1))/*(result)[++resultIndex];*/] = (byte)46;
					Memories.byteMemory[(result + ((++resultIndex) * 1))/*(result)[++resultIndex];*/] = (byte)48;
				}
				
			}
			
		}
		
		IceteaRuntimeSupport.free(f10Bytes);
		return (String)IceteaRuntimeSupport.i2j_return(new String( result, null), i2j_allocaPtr);
	}
	private static int IntToString10(int i) {
		int i2j_allocaPtr = IceteaRuntimeSupport.currentAllocaPtr();
		if(i == -2147483648) 
			return IceteaRuntimeSupport.i2j_return(IceteaRuntimeSupport.allocateArray(new byte[] { (byte)45, (byte)50, (byte)49, (byte)52, (byte)55, (byte)52, (byte)56, (byte)51, (byte)54, (byte)52, (byte)56}), i2j_allocaPtr);
		
		int maxLength = 11;
		int buffer = Thread.currentThread().allocateArrayNoInit(maxLength, 1)/*new byte[maxLength];*/;/*byte[] buffer = new byte[maxLength];*/
		boolean neg = i < 0;
		if(neg) 
			i = -i;
		
		int ptr = maxLength;
		
		do{
			Memories.byteMemory[(buffer + ((--ptr) * 1))/*(buffer)[--ptr];*/] = (byte)FPUtil.charValue(i % 10);
			i /= 10;
		}
		while(i != 0);
		if(neg) 
			Memories.byteMemory[(buffer + ((--ptr) * 1))/*(buffer)[--ptr];*/] = (byte)45;
		
		int resultLength = maxLength - ptr;
		int result = IceteaRuntimeSupport.allocateArrayNoInit(resultLength, 1)/*new byte[resultLength];*/;/*byte[] result = new byte[resultLength];*/
		Array.copy8Bits(buffer, ptr, result, 0, resultLength);
		return IceteaRuntimeSupport.i2j_return(result, i2j_allocaPtr);
	}
	private static int LongToString10(long l) {
		int i2j_allocaPtr = IceteaRuntimeSupport.currentAllocaPtr();
		if(l == -9223372036854775808l) 
			return IceteaRuntimeSupport.i2j_return(IceteaRuntimeSupport.allocateArray(new byte[] { (byte)45, (byte)57, (byte)50, (byte)50, (byte)51, (byte)51, (byte)55, (byte)50, (byte)48, (byte)51, (byte)54, (byte)56, (byte)53, (byte)52, (byte)55, (byte)55, (byte)53, (byte)56, (byte)48, (byte)56}), i2j_allocaPtr);
		
		int maxLength = 20;
		int buffer = Thread.currentThread().allocateArrayNoInit(maxLength, 1)/*new byte[maxLength];*/;/*byte[] buffer = new byte[maxLength];*/
		boolean neg = l < 0l;
		if(neg) 
			l = -l;
		
		int ptr = maxLength;
		
		do{
			Memories.byteMemory[(buffer + ((--ptr) * 1))/*(buffer)[--ptr];*/] = (byte)FPUtil.charValue((int)(l % 10l));
			l /= 10l;
		}
		while(l != 0l);
		if(neg) 
			Memories.byteMemory[(buffer + ((--ptr) * 1))/*(buffer)[--ptr];*/] = (byte)45;
		
		int resultLength = maxLength - ptr;
		int result = IceteaRuntimeSupport.allocateArrayNoInit(resultLength, 1)/*new byte[resultLength];*/;/*byte[] result = new byte[resultLength];*/
		Array.copy8Bits(buffer, ptr, result, 0, resultLength);
		return IceteaRuntimeSupport.i2j_return(result, i2j_allocaPtr);
	}
	private static char charValue(int digit) {
		if((digit >= 0) && (digit <= 9)) 
			return (char)(digit + '0');
		
		return '?';
	}
	public static double ceil(double a) {
		if(((a != a) || (a == Double.POSITIVE_INFINITY)) || (a == Double.NEGATIVE_INFINITY)) 
			return a;
		
		if((a > 9.223372036854776E18d) || (a < -9.223372036854776E18d)) 
			return a;
		
		long lg = (long)a;
		if(a == ((double)lg)) 
			return a;
		
		if(a >= 0.0d) 
			return (double)(lg + 1l);
		else 
			return (double)lg;
		
	}
	public static double floor(double a) {
		if(((a != a) || (a == Double.POSITIVE_INFINITY)) || (a == Double.NEGATIVE_INFINITY)) 
			return a;
		
		if((a > 9.223372036854776E18d) || (a < -9.223372036854776E18d)) 
			return a;
		
		long lg = (long)a;
		if(a == ((double)lg)) 
			return a;
		
		if(a >= 0.0d) 
			return (double)lg;
		else 
			return (double)(lg - 1l);
		
	}
	public static long f2l(float floatVal) {
		if(floatVal > 9.223372E18f) 
			return 9223372036854775807l;
		
		if(floatVal < -9.223372E18f) 
			return -9223372036854775808l;
		
		return (long)floatVal;
	}
	public static long d2l(double doubleVal) {
		if(doubleVal > 9.223372036854776E18d) 
			return 9223372036854775807l;
		
		if(doubleVal < -9.223372036854776E18d) 
			return -9223372036854775808l;
		
		return (long)doubleVal;
	}
	public static int f2i(float floatVal) {
		if(floatVal >= 2.14748365E9f) 
			return 2147483647;
		
		if(floatVal <= -2.14748365E9f) 
			return -2147483648;
		
		return (int)floatVal;
	}
	public static int d2i(double doubleVal) {
		if(doubleVal >= 2.147483647E9d) 
			return 2147483647;
		
		if(doubleVal <= -2.147483648E9d) 
			return -2147483648;
		
		return (int)doubleVal;
	}
	public static float intBitsToFloatCheck(int integer) {
		if((2139095041 <= integer) || ((-8388607 <= integer) && (integer <= -1))) 
			return Float.NaN;
		
		return Float.intBitsToFloat(integer);
	}
	public static double longBitsToDoubleCheck(long l) {
		if((9218868437227405313l <= l) || ((-4503599627370495l <= l) && (l <= -1l))) 
			return Double.NaN;
		
		return Double.longBitsToDouble(l);
	}
	
}