/*
 * Java
 *
 * Copyright 2009-2013 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package iceTea.lang;


public class DoubleI2jNatives {
	/** Returns a representation of the specified floating-point value according to the
	 * IEEE 754 floating-point "double format" bit layout.
	 * 
	 * Bit 63 (the bit that is selected by the mask 0x8000000000000000L) represents the sign of
	 * the floating-point number. Bits 62-52 (the bits that are selected by the mask 0x7ff0000000000000L)
	 * represent the exponent. Bits 51-0 (the bits that are selected by the mask 0x000fffffffffffffL)
	 * represent the significand (sometimes called the mantissa) of the floating-point number.
	 * 
	 * If the argument is positive infinity, the result is 0x7ff0000000000000L.
	 * If the argument is negative infinity, the result is 0xfff0000000000000L.
	 * If the argument is NaN, the result is 0x7ff8000000000000L.
	 * 
	 * In all cases, the result is a long integer that, when given to the longBitsToDouble(long) method,
	 * will produce a floating-point value equal to the argument to doubleToLongBits().
	 */
	public static long doubleToLongBits(double value) {
		return java.lang.Double.doubleToLongBits(value);
	}
	
	 /** Returns the double-float corresponding to a given bit representation. The argument is considered
     * to be a representation of a floating-point value according to the IEEE 754 floating-point
     * "double precision" bit layout. That floating-point value is returned as the result.
     * 
     * If the argument is 0x7ff0000000000000L, the result is positive infinity.
     * If the argument is 0xfff0000000000000L, the result is negative infinity.
     * If the argument is any value in the range 0x7ff0000000000001L through 0x7fffffffffffffffL or
     * in the range 0xfff0000000000001L through 0xffffffffffffffffL, the result is NaN.
     * 
     * All IEEE 754 NaN values of type double are, in effect, lumped together by the
     * Java programming language into a single value called NaN.
     * 
     * In all other cases, let s, e, and m be three values that can be computed from the argument:
     * 
     *      int s = ((bits >> 63) == 0) ? 1 : -1;
     *      int e = (int)((bits >> 52) & 0x7ffL);
     *      long m = (e == 0) ?
     *                      (bits & 0xfffffffffffffL) << 1 :
     *                      (bits & 0xfffffffffffffL) | 0x10000000000000L;
     * 
     * Then the floating-point result equals the value of the mathematical expression s?m?2e-1075
     */
	public static double longBitsToDouble(long bits){
		return java.lang.Double.longBitsToDouble(bits);
	}

	public static final boolean isNaNIntern(double v)
	{
		return Double.isNaN(v);
	}
}
