package iceTea.lang;

import iceTea.lang.support.IceteaStringSupport;
import iceTea.lang.support.IceteaRuntimeSupport;
import iceTea.lang.String;
import iceTea.lang.Object;
import iceTea.lang.Memories;
import iceTea.lang.FPUtil;
import iceTea.lang.DoubleI2jNatives;
import iceTea.lang.Double;
import iceTea.lang.Data;

public class Double extends Object{

	private static final long IMPLIED_ONE = 4503599627370496l;
	private static final long NEGATIVE_ZERO = -9223372036854775808l;
	private static final long ZERO = 0l;
	private static final long NEGATIVE_INFINITY_LONG = -4503599627370496l;
	private static final long POSITIVE_INFINITY_LONG = 9218868437227405312l;
	private static final long IMPLICIT_BIT = 4503599627370496l;
	private static final long FRAC_MASK = 4503599627370495l;
	private static final int EXP_OFFSET = 52;
	private static final long EXP_MASK = 9218868437227405312l;
	private static final long SIGN_MASK = -9223372036854775808l;
	private static final String DOUBLE_F2 = IceteaStringSupport.internString("DOUBLE_F2");
	private static final String DOUBLE_E2 = IceteaStringSupport.internString("DOUBLE_E2");
	private static final String DOUBLE_F10 = IceteaStringSupport.internString("DOUBLE_F10");
	private static final String DOUBLE_E10 = IceteaStringSupport.internString("DOUBLE_E10");
	public static final char EXPOSANT_CHAR_2 = 'e';
	public static final char EXPOSANT_CHAR_1 = 'E';
	public static final double MIN_VALUE = 4.9E-324d;
	public static final double MAX_VALUE = 1.7976931348623157E308d;
	public static final double NaN = 0d/0d;
	public static final double NEGATIVE_INFINITY = -1d/0d;
	public static final double POSITIVE_INFINITY = 1d/0d;
	
	public Double() {
		super();
	}
	
	public static final long doubleToLongBits(double value) {
		return DoubleI2jNatives.doubleToLongBits(value);
	}
	public static final double longBitsToDouble(long bits) {
		return DoubleI2jNatives.longBitsToDouble(bits);
	}
	public static boolean isInfinite(double v) {
		return (v == -1d/0d) || (v == 1d/0d);
	}
	private static final boolean isNaNIntern(double v) {
		return DoubleI2jNatives.isNaNIntern(v);
	}
	public static final boolean isNaN(double v) {
		return Double.isNaNIntern(v);
	}
	public static double parseDouble(String s) {
		String s2 = s.trim();
		int bytes = s2.toByteArray();/*byte[] bytes = s2.toByteArray();*/
		double result = Double.parseDouble___3BII(bytes, 0, Memories.intMemory[((bytes - 4)/*length*/ >> 2)]);
		IceteaRuntimeSupport.free(bytes);
		if(s2 != s) 
			s2.dispose();
		
		return result;
	}
	public static double parseDouble___3BCC(int bytes, char start, char length) {
		return Double.parseDouble___3BII(bytes, (int)start, (int)length);
	}
	public static double parseDouble___3BII(int bytes, int offset, int length) {
		if(length == 0) 
			return 0d/0d;
		
		int stop = offset + length;
		boolean neg = false;
		
		switch( (byte)(Memories.byteMemory)[(bytes + (0 * 1))/*(bytes)[0];*/]){
				
			case (byte)45 : 
				neg = true;
				
			case (byte)43 : 
				++offset;
		}
		if(offset == stop) 
			return 0d/0d;
		
		byte current = (byte)(Memories.byteMemory)[(bytes + (offset * 1))/*(bytes)[offset];*/];
		if(current == 'I') {
			if(((((((((stop - offset) != 8) || (((byte)(Memories.byteMemory)[(bytes + ((offset + 1) * 1))/*(bytes)[offset+1];*/]) != 'n')) || (((byte)(Memories.byteMemory)[(bytes + ((offset + 2) * 1))/*(bytes)[offset+2];*/]) != 'f')) || (((byte)(Memories.byteMemory)[(bytes + ((offset + 3) * 1))/*(bytes)[offset+3];*/]) != 'i')) || (((byte)(Memories.byteMemory)[(bytes + ((offset + 4) * 1))/*(bytes)[offset+4];*/]) != 'n')) || (((byte)(Memories.byteMemory)[(bytes + ((offset + 5) * 1))/*(bytes)[offset+5];*/]) != 'i')) || (((byte)(Memories.byteMemory)[(bytes + ((offset + 6) * 1))/*(bytes)[offset+6];*/]) != 't')) || (((byte)(Memories.byteMemory)[(bytes + ((offset + 7) * 1))/*(bytes)[offset+7];*/]) != 'y')) 
				return 0d/0d;
			
			if(neg) 
				return -1d/0d;
			
			return 1d/0d;
		}
		
		if(((current < '0') || (current > '9')) && (current != '.')) 
			return 0d/0d;
		
		int e = 0;
		long f = 0l;
		byte lastChar = (byte)(Memories.byteMemory)[(bytes + ((stop - 1) * 1))/*(bytes)[stop-1];*/];
		if((lastChar == 'd') || (lastChar == 'D')) {
			stop--;
			lastChar = (byte)(Memories.byteMemory)[(bytes + ((stop - 1) * 1))/*(bytes)[stop-1];*/];
		}
		
		if((lastChar < '0') || (lastChar > '9')) 
			return 0d/0d;
		
		long fMaxValue = 922337203685477571l;
		
		while ((((offset < stop) && (((byte)(Memories.byteMemory)[(bytes + (offset * 1))/*(bytes)[offset];*/]) != '.')) && (((byte)(Memories.byteMemory)[(bytes + (offset * 1))/*(bytes)[offset];*/]) != 'E')) && (((byte)(Memories.byteMemory)[(bytes + (offset * 1))/*(bytes)[offset];*/]) != 'e')){
			current = (byte)(Memories.byteMemory)[(bytes + (offset * 1))/*(bytes)[offset];*/];
			if((current >= '0') && (current <= '9')) {
				if(f < fMaxValue) {
					f *= 10l;
					f += (long)(current - '0');
				}
				else 
					e++;
				
			}
			else 
				return 0d/0d;
			
			offset++;
		}
		
		if((offset < stop) && (((byte)(Memories.byteMemory)[(bytes + (offset * 1))/*(bytes)[offset];*/]) == '.')) {
			++offset;
			
			while (((offset < stop) && (((byte)(Memories.byteMemory)[(bytes + (offset * 1))/*(bytes)[offset];*/]) != 'E')) && (((byte)(Memories.byteMemory)[(bytes + (offset * 1))/*(bytes)[offset];*/]) != 'e')){
				current = (byte)(Memories.byteMemory)[(bytes + (offset * 1))/*(bytes)[offset];*/];
				if((current >= '0') && (current <= '9')) {
					if(f < fMaxValue) {
						f *= 10l;
						f += (long)(current - '0');
						e--;
					}
					
				}
				else 
					return 0d/0d;
				
				offset++;
			}
			
		}
		
		if((offset < stop) && ((((byte)(Memories.byteMemory)[(bytes + (offset * 1))/*(bytes)[offset];*/]) == 'E') || (((byte)(Memories.byteMemory)[(bytes + (offset * 1))/*(bytes)[offset];*/]) == 'e'))) {
			current = (byte)(Memories.byteMemory)[(bytes + ((++offset) * 1))/*(bytes)[++offset];*/];
			boolean negE = false;
			
			switch( current){
					
				case (byte)45 : 
					negE = true;
					
				case (byte)43 : 
					++offset;
			}
			int readE = 0;
			
			while (offset < stop){
				current = (byte)(Memories.byteMemory)[(bytes + (offset * 1))/*(bytes)[offset];*/];
				if(readE < 214748355) {
					if((current >= '0') && (current <= '9')) {
						readE *= 10;
						readE += current - '0';
					}
					else 
						return 0d/0d;
					
				}
				
				offset++;
			}
			
			if(readE >= 214748355) {
				if((!negE) && (f != 0l)) 
					return neg?-1d/0d:1d/0d;
				
				return Double.longBitsToDouble(neg?-9223372036854775808l:0l);
			}
			
			if(negE) 
				readE *= -1;
			
			e += readE;
		}
		
		if(offset != stop) 
			return 0d/0d;
		
		return Double.longBitsToDouble(Double.getDoubleBits(neg, f, e));
	}
	private static boolean IsNegative(long bits) {
		return (bits & -9223372036854775808l) != 0l;
	}
	private static int Exponent(long bits) {
		return (int)((bits & 9218868437227405312l) >> 52);
	}
	private static long Fraction(long bits) {
		return bits & 4503599627370495l;
	}
	public static String toString(double d) {
		long v = Double.doubleToLongBits(d);
		boolean isNeg = Double.IsNegative(v);
		int e = Double.Exponent(v);
		long f = Double.Fraction(v);
		if(e == 2047) {
			if(f != 0l) 
				return new String( IceteaStringSupport.internString("NaN"));
			
			return isNeg?new String( IceteaStringSupport.internString("-Infinity")):new String( IceteaStringSupport.internString("Infinity"));
		}
		
		if(e == 0) {
			if(f == 0l) 
				return isNeg?new String( IceteaStringSupport.internString("-0.0")):new String( IceteaStringSupport.internString("0.0"));
			
			f <<= 1;
		}
		else 
			f |= 4503599627370496l;
		
		long initialf = f;
		int fShift = e & 7;
		f <<= fShift;
		int eId = e >>> 3;
		int E10 = (int)Data.dataArrayAt(IceteaStringSupport.internString("DOUBLE_E10"));/*short[ro] E10 = ((short[ro])(iceTea.lang.Data.dataArrayAt(iceTea.lang.Double.DOUBLE_E10)));*/
		int F10 = (int)Data.dataArrayAt(IceteaStringSupport.internString("DOUBLE_F10"));/*long[ro] F10 = ((long[ro])(iceTea.lang.Data.dataArrayAt(iceTea.lang.Double.DOUBLE_F10)));*/
		int e10 = (int)Memories.getShort(E10 + (eId * 2)/*(E10)[eId];*/);
		
		while (f < 922337203685477580l){
			f *= 10l;
			e10--;
		}
		
		long f10 = Double.BigMul(f, Memories.getLong(F10 + (eId * 8)/*(F10)[eId];*/));
		if(Double.getDoubleBits(isNeg, f10, e10) == v) {
			
			while (true){
				long f10tmp = f10 / 10l;
				int e10tmp = e10 + 1;
				boolean rounding = (f10tmp % 10l) >= 5l;
				if(rounding) 
					f10tmp++;
				
				if(Double.getDoubleBits(isNeg, f10tmp, e10tmp) != v) {
					if(rounding) 
						f10tmp--;
					
					if(Double.getDoubleBits(isNeg, f10tmp, e10tmp) != v) 
						break;
					
				}
				
				f10 = f10tmp;
				e10 = e10tmp;
			}
			
		}
		else {
			long fplus = (initialf + 1l) << fShift;
			int nbMultiply = Memories.getShort(E10 + (eId * 2)/*(E10)[eId];*/) - e10;
			
			while ((f < 922337203685477580l) && ((--nbMultiply) >= 0)){
				fplus *= 10l;
			}
			
			fplus = Double.BigMul(fplus, Memories.getLong(F10 + (eId * 8)/*(F10)[eId];*/));
			
			while ((--nbMultiply) >= 0){
				boolean roundup = (f10 % 10l) >= 5l;
				f10 /= 10l;
				e10++;
				if(roundup) 
					f10++;
				
			}
			
			long diffplus = fplus - f10;
			
			while (diffplus > 10l){
				boolean f10Roundup = (f10 % 10l) >= 5l;
				f10 /= 10l;
				if(f10Roundup) 
					f10++;
				
				boolean fplusRoundup = (fplus % 10l) >= 5l;
				fplus /= 10l;
				if(fplusRoundup) 
					fplus++;
				
				diffplus = fplus - f10;
				e10++;
			}
			
			int valueRange = ((int)diffplus) >>> 1;
			for( int i = -valueRange; i <= valueRange; i++)
			{
				if(((f10 + ((long)i)) % 10l) == 0l) {
					f10 += (long)i;
					break;
				}
				
			}
			
		}
		
		return FPUtil.toString10(isNeg, f10, e10, -3, 7);
	}
	private static long getDoubleBits(boolean neg, long f10, int e10) {
		long f2 = f10;
		
		while ((f2 > 0l) && (f2 < 922337203685477580l)){
			f2 *= 10l;
			e10--;
		}
		
		e10 += 343;
		if((e10 < 0) || (f10 == 0l)) {
			return neg?-9223372036854775808l:0l;
		}
		else 
			if(e10 > 652) {
				return neg?-4503599627370496l:9218868437227405312l;
			}
			
		
		int x10 = e10 & 7;
		int eId = e10 >> 3;
		int E2 = (int)Data.dataArrayAt(IceteaStringSupport.internString("DOUBLE_E2"));/*short[ro] E2 = ((short[ro])(iceTea.lang.Data.dataArrayAt(iceTea.lang.Double.DOUBLE_E2)));*/
		int F2 = (int)Data.dataArrayAt(IceteaStringSupport.internString("DOUBLE_F2"));/*long[ro] F2 = ((long[ro])(iceTea.lang.Data.dataArrayAt(iceTea.lang.Double.DOUBLE_F2)));*/
		int e2 = (int)Memories.getShort(E2 + (eId * 2)/*(E2)[eId];*/);
		int shift = FPUtil.nbZeros(f2);
		f2 <<= shift;
		e2 -= shift;
		f2 = Double.BigMul(f2, Memories.getLong(F2 + (eId * 8)/*(F2)[eId];*/));
		if(x10 > 0) {
			
			while ((--x10) >= 0){
				if(f2 < 0l) {
					f2 >>>= 1;
					e2++;
				}
				
				f2 += f2 >>> 2;
				e2 += 3;
			}
			
		}
		
		shift = FPUtil.nbZeros(f2);
		f2 <<= shift;
		e2 -= shift;
		long resultMask;
		if(e2 < -1085) {
			resultMask = FPUtil.shiftRightWithRounding(f2, -1074 - e2);
			if((resultMask == 0l) && (f2 != 0l)) 
				resultMask = 1l;
			
		}
		else {
			f2 = FPUtil.shiftRightWithRounding(f2, 11);
			if(f2 == 9007199254740992l) {
				f2 = 4503599627370496l;
				e2++;
			}
			
			if(e2 > 962) {
				return neg?-4503599627370496l:9218868437227405312l;
			}
			
			resultMask = f2 ^ 4503599627370496l;
			resultMask |= (long)(((long)(e2 + 1086)) << 52);
		}
		
		if(neg) 
			resultMask |= -9223372036854775808l;
		
		return resultMask;
	}
	private static long BigMul(long l1, long l2) {
		long x1 = (l1 >>> 32) & 4294967295l;
		long y1 = l1 & 4294967295l;
		long x2 = (l2 >>> 32) & 4294967295l;
		long y2 = l2 & 4294967295l;
		long result = x1 * x2;
		long low = (x1 * y2) + (x2 * y1);
		result += low >>> 32;
		if((low & -2147483648l) != 0l) 
			result++;
		
		return result;
	}
	
}