package iceTea.lang;

import iceTea.lang.support.I2JCheckConstants;
import iceTea.lang.support.I2jConstants;
import iceTea.lang.support.IceteaArraySupport;
import iceTea.lang.support.IceteaRuntimeSupport;
import iceTea.lang.support.TraceHelper;

public abstract class Array implements I2jConstants {

	/**
	 * Copy Array at address addrSrc to Array at addrDest.
	 * copy indexes at [addrSrc+srcPos, addrSrc+srcPos+(length*data size)[ 
	 * 				to [addrDest+srcDest, addrDest+srcDest+length*data size[
	 * @param addrSrc : array source address in Memories
	 * @param srcPos  : first index of source to copy
	 * @param addrDest: array destination address in Memories
	 * @param destPos :  first index of destination
	 * @param length  :  nbElement to copy
	 */
	public static void copy8Bits( int addrSrc , int srcPos, int addrDest, int destPos, int length) {	
		if  (I2JCheckConstants.ACTIVATE_CHECK) {
			if ( TraceHelper.BREAKPOINT_ON_MEMORIES == 1)
				TraceHelper.checkAccessTo( addrDest+ destPos*BYTE_SIZE, length*BYTE_SIZE);
   
     		i2j_checkBound( addrSrc, srcPos, addrDest, destPos, length);
		}	
     	
		Memories.memcpy( 0,  addrSrc+ srcPos*BYTE_SIZE,  0,  addrDest+ destPos*BYTE_SIZE,  length*BYTE_SIZE); 
	}
	
	public static void copy16Bits( int addrSrc , int srcPos, int addrDest, int destPos, int length) {	
		if  (I2JCheckConstants.ACTIVATE_CHECK) {
			if ( TraceHelper.BREAKPOINT_ON_MEMORIES == 1) {
				TraceHelper.checkAccessTo( addrDest+ destPos*CHAR_SIZE, length*CHAR_SIZE);
			}
    
			i2j_checkBound( addrSrc, srcPos, addrDest, destPos, length);
		}	
	 	
		Memories.memcpy( 0,  addrSrc+ srcPos*CHAR_SIZE,  0,  addrDest+ destPos*CHAR_SIZE,  length*CHAR_SIZE); 
	}
	
	public static void copy32Bits( int addrSrc , int srcPos, int addrDest, int destPos, int length) {
		if  (I2JCheckConstants.ACTIVATE_CHECK) {
			if ( TraceHelper.BREAKPOINT_ON_MEMORIES == 1) {
				TraceHelper.checkAccessTo( addrDest+ destPos*INT_SIZE, length*INT_SIZE);
			}
	
			i2j_checkBound( addrSrc, srcPos, addrDest, destPos, length);
		}		
		
		Memories.memcpy( 0,  addrSrc+ srcPos*INT_SIZE,  0,  addrDest+ destPos*INT_SIZE,  length*INT_SIZE); 
	}
	
	public static void copy64Bits( int addrSrc , int srcPos, int addrDest, int destPos, int length) {
		if  (I2JCheckConstants.ACTIVATE_CHECK) {
			if ( TraceHelper.BREAKPOINT_ON_MEMORIES == 1) {
				TraceHelper.checkAccessTo( addrDest+ destPos*LONG_SIZE, length*LONG_SIZE);
			}

			i2j_checkBound( addrSrc, srcPos, addrDest, destPos, length);
		}		

		
		Memories.memcpy( 0,  addrSrc+ srcPos*LONG_SIZE,  0,  addrDest+ destPos*LONG_SIZE,  length*LONG_SIZE); 
	}
	
	public static void i2j_checkBound(int addrSrc, int srcPos, int addrDest, int destPos, int length) {
		// check bounds as java.lang.System.arraycopy will throw an IndexOutOfBoundsException (same rules)
	    // 1) The srcPos argument is negative.
		IceteaRuntimeSupport.assertCheck(!(srcPos < 0));
		// 2) The destPos argument is negative.
		IceteaRuntimeSupport.assertCheck(!(destPos < 0));
		// 3) The length argument is negative.
		IceteaRuntimeSupport.assertCheck(!(length < 0));
		// 4) srcPos+length is greater than src.length, the length of the source array.
		IceteaRuntimeSupport.assertCheck(!(srcPos+length>IceteaArraySupport.length(addrSrc)));
		// 5) destPos+length is greater than dest.length, the length of the destination array. 
		IceteaRuntimeSupport.assertCheck(!(destPos+length>IceteaArraySupport.length(addrDest)));
	}

}
