/*
 * Created on 24-Mar-2004
 */
package iceTea.io;
import iceTea.lang.String;
import iceTea.lang.support.IceteaArraySupport;

/**
 * @author IST
 * 
 * Abstract class for writing to character streams. The only methods that a
 * subclass must implement are write(char[], int, int), flush(), and close().
 * Most subclasses, however, will override some of the methods defined here in
 * order to provide higher efficiency, additional functionality, or both.
 */
public abstract class Writer extends Object {

    /**
     * The object used to synchronize operations on this stream. For
     * efficiency, a character-stream object may use an object other than
     * itself to protect critical sections. A subclass should therefore use the
     * object in this field rather than this or a synchronized method.
     */
    protected Object lock ;

    /**
     * Create a new character-stream writer whose critical sections will
     * synchronize on the writer itself.
     */
    protected Writer() {
    	this.lock = this ;
    }
    
    /**
     * Create a new character-stream writer whose critical sections will
     * synchronize on the given object.
     */
    protected Writer(Object lock) {
    	if (lock == null)
    		throw new NullPointerException("Cannot synchronize on 'null'") ;
    	this.lock = lock ;
    }
    
    /**
     * Close the stream, flushing it first. Once a stream has been closed,
     * further write() or flush() invocations will cause an IOException to be
     * thrown. Closing a previously-closed stream, however, has no effect.
     */
    public abstract void close() throws IOException ;

    /**
     * Flush the stream. If the stream has saved any characters from the
     * various write() methods in a buffer, write them immediately to their
     * intended destination. Then, if that destination is another character or
     * byte stream, flush it. Thus one flush() invocation will flush all the
     * buffers in a chain of Writers and OutputStreams.
     */
    public abstract void flush() throws IOException ;

    /**
     * Write an array of characters.
     */
    public void write(byte[] cbuf) throws IOException {
    	write(cbuf, 0, cbuf.length) ;
    }
    
    public void write___ibyte1(int bytes) throws IOException {
    	write___ibyte1_iint_iint( bytes, 0, IceteaArraySupport.length( bytes)) ;
    }
 
    
    /**
     * Write a portion of an array of characters.
     */
    public abstract void write(byte[] cbuf,  int off, int len) throws IOException 
	// Subclasses should use 'lock' field to synchronize the writing of the argument 'cbuf'.
	;
    public abstract void write___ibyte1_iint_iint(int bytes,  int off, int len) throws IOException;

    /**
     * Write a single character. The character to be written is contained in
     * the 16 low-order bits of the given integer value; the 16 high-order bits
     * are ignored.
     * 
     * Subclasses that intend to support efficient single-character output
     * should override this method.
     */
    public void write(int c) throws IOException {
    	write(new byte[]{(byte)c}) ;
    }

    /**
     * Write a string.
     */
    public void write(String str) throws IOException {
    	write (str, 0, str.length()) ;
    }

    /**
     * Write a portion of a string.
     */
    public void write(String str, int off, int len) throws IOException {
    	write___ibyte1_iint_iint ( str.chars, off, len) ;

    }

}
