/*
 * Created on 24-Mar-2004
 */
package iceTea.io;

import iceTea.lang.Memories;

/**
 * @author IST
 *
 * An OutputStreamWriter is a bridge from character streams to byte streams:
 * Characters written to it are translated into bytes. The encoding that it
 * uses may be specified by name, or the platform's default encoding may be
 * accepted.
 *
 * Each invocation of a write() method causes the encoding converter to be
 * invoked on the given character(s). The resulting bytes are accumulated in a
 * buffer before being written to the underlying output stream. The size of
 * this buffer may be specified, but by default it is large enough for most
 * purposes. Note that the characters passed to the write() methods are not
 * buffered.
 */
public class OutputStreamWriter extends Writer {

	//this static is assumed ot be always ISO-8859-1
	//public static String DefaultEncoding = System.getProperty("microedition.encoding");

	/* INSTANCE VARIABLES */

	OutputStream out ;

    /**
     * Create an OutputStreamWriter that uses the default character encoding.
     */
    public OutputStreamWriter(OutputStream os) {
    	this.out = os ;
    }

    /**
     * Close the stream.
     */
	@Override
	public void close() throws IOException {
		if(out != null){
			out.close();
			out = null;
		}

	}

    /**
     * Flush the stream.
     */
	@Override
	public void flush() throws IOException {
		if(out != null)
			out.flush();
		else
			throw new IOException();
	}

    /**
     * Write a portion of an array of characters.
     */
	@Override
	public void write(byte[] cbuf, int off, int len) throws IOException {
		if(out != null){
			//don't have to test if off,len, off+len are out of bounds,
			//an ArrayIndexOutOfBoundsException will be thrown.
			//only support ISO-8859-1 translation *aka ASCII*
			byte[] bytes = new byte[len];
			int count = len;
			off += len;

			while(--count>=0) bytes[count]=(byte)cbuf[--off];
			out.write(bytes,0,len);
		}
		else
			throw new IOException();
	}

	@Override
	public void write___ibyte1_iint_iint( int byteArray, int off, int len) throws IOException {
		if(out != null){
			//don't have to test if off,len, off+len are out of bounds,
			//an ArrayIndexOutOfBoundsException will be thrown.
			//only support ISO-8859-1 translation *aka ASCII*
			byte[] bytes = new byte[len];
			int count = len;
			off += (len + byteArray);

			while(--count>=0) {
				bytes[count]=(byte)Memories.getByte(--off);
			}

			out.write(bytes,0,len);
		}
		else
			throw new IOException();
	}


}
