/**
 * Java
 *
 * Copyright 2009-2012 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package iceTea.io;

import iceTea.lang.Object;
import iceTea.lang.support.IceteaArraySupport;

import java.io.FileDescriptor;
import java.io.FileNotFoundException;


public class FileOutputStream extends Object{

    private java.io.FileOutputStream fileOutputStream;
    
    public FileOutputStream(iceTea.io.File file){
        try{
            fileOutputStream = new java.io.FileOutputStream(file.getFile());
        }
        catch(FileNotFoundException e){}
    }

    public FileOutputStream(FileDescriptor fdObj){
        fileOutputStream = new java.io.FileOutputStream(fdObj);
    }

    public FileOutputStream(iceTea.lang.String name){
        try{
            fileOutputStream = new java.io.FileOutputStream(name.toString());
        }
        catch(FileNotFoundException e){}
    }

    public FileOutputStream(iceTea.io.File file,boolean append){
        try{
            fileOutputStream = new java.io.FileOutputStream(file.getFile(),append);
        }
        catch(FileNotFoundException e){}
    }

    public FileOutputStream(iceTea.lang.String name,boolean append){
        try{
            fileOutputStream = new java.io.FileOutputStream(name.toString(),append);
        }
        catch(FileNotFoundException e){}
    }

    
    /**
     * Closes this output stream and releases any system resources associated with the stream.
     * The close method of FilterOutputStream calls its flush method, and then calls the close
     * method of its underlying output stream.
     */
    public void close(){
        try{
            fileOutputStream.close();
        }
        catch(java.io.IOException e){}
        catch(NullPointerException e){}
    }
    
    //return -1 on error
    public int write(int b){
        try{
            fileOutputStream.write(b);
            return 0;
        }
        catch(java.io.IOException e){
            return -1;
        }
        catch(NullPointerException e){
            return -1;
        }
    }

    
    /**
     * Attempts to write out len bytes from the array buf
     * into this file.
     * 
     * @return -1 if an error occured, return 0 otherwise
     * @see java.io.OutputStream#write(byte[], int, int)
     */
     public int write(byte[] buf, int off, int len){
        try{
            fileOutputStream.write(buf,off,len);
            return 0;
        }
        catch(java.io.IOException e){
            return -1;
        }
        catch(NullPointerException e){
            return -1;
        }
    }
     
     public int write___3BII(int bytes , int off, int len) {
      byte[] buf = new byte[ len];
      IceteaArraySupport.fromIceTeaToJavaArray(bytes +off, len, buf);
      return write( buf, off, len);
     }
    	 
    
    /**
     * Write all bytes of Memories.ram from ramPtr to ramPtr+len into this file.
     * 
     * @return -1 if an error occurred, return 0 otherwise
     */
  
    public int write(int ramPtr, int len){
    	byte[] bytes = new byte[len];
    	IceteaArraySupport.fromIceTeaToJavaArray(ramPtr, len, bytes);
    
        try{
            fileOutputStream.write( bytes,0,len);
            return 0;
        }
        catch(java.io.IOException e){
            return -1;
        }
        catch(NullPointerException e){
            return -1;
        }
    }
    
    @Override
	public void dispose(){}
}
