/**
 * Java
 *
 * Copyright 2009-2012 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package iceTea.io;

import iceTea.lang.support.IceteaArraySupport;

import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;


public class FileInputStream extends iceTea.lang.Object{

    private java.io.FileInputStream fileInputStream;
    
    public FileInputStream(iceTea.io.File file){
        try{
            fileInputStream = new java.io.FileInputStream(file.getFile());
        }
        catch(FileNotFoundException e){}
    }

    public FileInputStream(FileDescriptor fdObj){
        fileInputStream = new java.io.FileInputStream(fdObj);
    }

    public FileInputStream(iceTea.lang.String name){
        try{
            fileInputStream = new java.io.FileInputStream(name.toString());
        }
        catch(FileNotFoundException e){}
    }
    
    @Override
	public void dispose() {
    	
    }
    
    /**
     * Return the number of bytes which can be read in from the input file.
     * Return -1 on error.
     * 
     * @see java.io.InputStream#available()
     */
    public int available(){
        try{
            return fileInputStream.available();
        }
        catch(java.io.IOException e){
            return -1;
        }
        catch(NullPointerException e){
            return -1;
        }
    }

    
    /**
     * Reads in the file a single byte.
     * 
     * @see java.io.InputStream#read()
     */
    public int read(){
        try{
            return fileInputStream.read();
        }
        catch(IOException e){
            return -1;
        }
        catch(NullPointerException e){
            return -1;
        }
    }
    
    
    /**
     * Attempts to read in 'len' bytes from the input stream and stores them
     * into the byte array 'buf'.
     * 
     * @return the total number of bytes read into the buffer,
     * or -1 if there is no more data because the end of the stream has been reached.
     * @see java.io.InputStream#read(byte[], int, int)
     */
    public int read(byte[] buf, int off, int len){
        try{
            return fileInputStream.read(buf,off,len);
        }
        catch(IOException e){
            return IO.IOERROR;
        }
        catch(NullPointerException e){
            return IO.IOERROR;
        }
    }
 
    public int read___3BII( int byteArray, int off, int len){
    	byte[] buf = new byte[ len];
    	int i = read( buf, 0, len);
    	if ( i == -1)
    		return i;
    	// copy readed byte in byteArray
    	IceteaArraySupport.fromJavaToIceteaArray(buf, byteArray+off, len);
    	return i;
    }

    /**
     * Closes the file input stream.
     * 
     * @see java.io.InputStream#close()
     */
    //the file descriptor becomes invalid
    public void close(){
        try{
            fileInputStream.close();
        }
        catch(IOException e){}
        catch(NullPointerException e){}
    }
    
    
    /**
     * Attempts to skip n bytes and returns the effective number of bytes
     * skipped.
     * 
     * @see java.io.InputStream#skip()
     */
    public long skip(long n){
        try{
            return fileInputStream.skip(n);
        }
        catch(IOException e){
            return -1L;
        }
        catch(NullPointerException e){
            return -1L;
        }
    }
    
}
