/********************************************/
/* Copyright Industrial Software Technology */
/********************************************/

package iceTea.io;

import iceTea.lang.support.IceteaStringSupport;

import java.io.IOException;
import java.net.URI;


public class File extends iceTea.lang.Object{

    public static final byte separatorChar = (byte)java.io.File.separatorChar;
    public static final byte pathSeparatorChar = (byte)java.io.File.pathSeparatorChar;

    public static final iceTea.lang.String separator= IceteaStringSupport.fromJavaLangString(java.io.File.separator);
    public static final iceTea.lang.String pathSeparator=IceteaStringSupport.fromJavaLangString(java.io.File.pathSeparator);

    public static void freeFile(){
    	separator.dispose();
    	pathSeparator.dispose();
    }

    private java.io.File file;

    public java.io.File getFile(){
    	 return file;
    }

    public File(iceTea.lang.String pathname){
        file = new java.io.File(pathname.toString());
    }


    public File(URI uri){
        file = new java.io.File(uri);
    }

    public File(File parent,iceTea.lang.String child){
        file = new java.io.File(parent.getFile(),child.toString());
    }

    public File(iceTea.lang.String parent,iceTea.lang.String child){
        file = new java.io.File(parent.toString(),child.toString());
    }

    @Override
	public void dispose(){}

    /**
     * Tests whether the application can read the file denoted by this abstract pathname.
     *
     * @return true if and only if the file specified by this abstract pathname exists and can be read by the application; false otherwise
     */
    public boolean canRead(){
        return file.canRead();
    }


    /**
     * Tests whether the application can modify to the file denoted by this abstract pathname.
     *
     * @return true if and only if the file system actually contains a file denoted by this abstract pathname and
     * the application is allowed to write to the file; false otherwise.
     */
    public boolean canWrite(){
        return file.canWrite();
    }


    /**
     * Atomically creates a new, empty file named by this abstract pathname if and only if a file with
     * this name does not yet exist. The check for the existence of the file and the creation of the file
     * if it does not exist are a single operation that is atomic with respect to all other filesystem
     * activities that might affect the file.
     * Note: this method should not be used for file-locking, as the resulting protocol cannot be made to
     * work reliably. The FileLock facility should be used instead.
     *
     * @return true if the named file does not exist and was successfully created; false if the named file already exists
     */
    public boolean createNewFile(){
        try{
            return file.createNewFile();
        }
        catch(IOException e){
            return false;
        }
    }


    /**
     * Deletes the file or directory denoted by this abstract pathname.
     * If this pathname denotes a directory, then the directory must be empty in order to be deleted.
     *
     * @return true if and only if the file or directory is successfully deleted; false otherwise
     */
    public boolean delete(){
        return file.delete();
    }
    public boolean delete_(){ //for ICETEA
    	return delete();
    }


    /**
     * Tests this abstract pathname for equality with the given object.
     * Returns true if and only if the argument is not null and is an abstract pathname that denotes the
     * same file or directory as this abstract pathname. Whether or not two abstract pathnames are equal
     * depends upon the underlying system.
     * On UNIX systems, alphabetic case is significant in comparing pathnames; on Microsoft Windows systems it is not.
     *
     * @return true if and only if the objects are the same; false otherwise
     */
    @Override
	public boolean equals(Object o){
        return file.equals(o);
    }


    /**
     * Tests whether the file or directory denoted by this abstract pathname exists.
     *
     * @return true if and only if the file or directory denoted by this abstract pathname exists; false otherwise
     */
    public boolean exists(){
        return file.exists();
    }


    /**
     * Returns the absolute form of this abstract pathname. Equivalent to new File(this.getAbsolutePath()()).
     *
     * @return The absolute abstract pathname denoting the same file or directory as this abstract pathname, null if there is an error
     */
    public File getAbsoluteFile(){
        return new File(this.getAbsolutePath());
    }


    /**
     * Returns the absolute pathname string of this abstract pathname.
     * If this abstract pathname is already absolute, then the pathname string is simply returned as if by the getPath() method.
     * If this abstract pathname is the empty abstract pathname then the pathname string of the current user directory, which is
     * named by the system property user.dir, is returned. Otherwise this pathname is resolved in a system-dependent way.
     * On UNIX systems, a relative pathname is made absolute by resolving it against the current user directory.
     * On Microsoft Windows systems, a relative pathname is made absolute by resolving it against the current directory of the
     * drive named by the pathname, if any; if not, it is resolved against the current user directory.
     *
     * NOTE :Sender should free the return string
     *
     * @return The absolute pathname string denoting the same file or directory as this abstract pathname, null if there is an error
     */
    public iceTea.lang.String getAbsolutePath(){
    	return IceteaStringSupport.fromJavaLangString(file.getAbsolutePath());
    }


    /**
     * Returns the canonical form of this abstract pathname. Equivalent to new File(this.getCanonicalPath()()).
     *
     * NOTE :Sender should free the return string
     *
     * @return The canonical pathname string denoting the same file or directory as this abstract pathname, null if there is an error
     */
    public File getCanonicalFile(){
        return new File(this.getCanonicalPath());
    }


    /**
     * Returns the canonical pathname string of this abstract pathname.
     * A canonical pathname is both absolute and unique. The precise definition of canonical form is system-dependent.
     * This method first converts this pathname to absolute form if necessary, as if by invoking the getAbsolutePath()
     * method, and then maps it to its unique form in a system-dependent way. This typically involves removing redundant
     * names such as "." and ".." from the pathname, resolving symbolic links (on UNIX platforms), and converting drive
     * letters to a standard case (on Microsoft Windows platforms).
     *
     * Every pathname that denotes an existing file or directory has a unique canonical form. Every pathname that denotes
     * a nonexistent file or directory also has a unique canonical form. The canonical form of the pathname of a nonexistent
     * file or directory may be different from the canonical form of the same pathname after the file or directory is created.
     * Similarly, the canonical form of the pathname of an existing file or directory may be different from the canonical form
     * of the same pathname after the file or directory is deleted.
     *
   	 * NOTE :Sender should free the return string
   	 *
     *  @return The canonical pathname string denoting the same file or directory as this abstract pathname, null on error.
     */
    public iceTea.lang.String getCanonicalPath(){
        try{
        	return IceteaStringSupport.fromJavaLangString(file.getCanonicalPath());
         }
        catch(IOException e){
            return null;
        }
    }

    /**
     * Sender should free the return string
     * @return
     */
    public iceTea.lang.String getName(){
    	return IceteaStringSupport.fromJavaLangString(file.getName());
    }

    /**
     * Sender should free the return string
     * @return
     */
    public iceTea.lang.String getParent(){
    	return IceteaStringSupport.fromJavaLangString(file.getParent());
     }

    /**
     * Sender should free the return File
     * @return
     */
    public File getParentFile(){
        return new File(getParent());
    }

    /**
     * Sender should free the return string
     * @return
     */
    public iceTea.lang.String getPath(){
     	return IceteaStringSupport.fromJavaLangString(file.getPath());
    }

    public boolean isAbsolute(){
        return file.isAbsolute();
    }


    /**
     * Tests whether the file denoted by this abstract pathname is a directory.
     *
     * @return  true if and only if the file denoted by this abstract pathname exists and is a directory;
     *          false otherwise
     */
    public boolean isDirectory(){
        return file.isDirectory();
    }


    /**
     * Tests whether the file denoted by this abstract pathname is a normal file. A file is normal if it is not
     * a directory and, in addition, satisfies other system-dependent criteria. Any non-directory file created
     * by a Java application is guaranteed to be a normal file.
     *
     * @return true if and only if the file denoted by this abstract pathname exists and is a normal file; false otherwise
     */
    public boolean isFile(){
        return file.isFile();
    }


    /**
     * Tests whether the file named by this abstract pathname is a hidden file. The exact definition of hidden is system-dependent.
     * On UNIX systems, a file is considered to be hidden if its name begins with a period character ('.').
     * On Microsoft Windows systems, a file is considered to be hidden if it has been marked as such in the filesystem.
     *
     * @return true if and only if the file denoted by this abstract pathname is hidden according to the conventions of the underlying platform
     */
    public boolean isHidden(){
        return file.isHidden();
    }


    /**
     * Returns the time that the file denoted by this abstract pathname was last modified.
     *
     * @return A long value representing the time the file was last modified, measured in milliseconds
     * since the epoch (00:00:00 GMT, January 1, 1970), or 0L if the file does not exist or if an I/O error occurs
     */
    public long lastModified(){
        return file.lastModified();
    }


    /**
     * Returns the length of the file denoted by this abstract pathname.
     * The return value is unspecified if this pathname denotes a directory.
     *
     * @return The length, in bytes, of the file denoted by this abstract pathname, or 0L if the file does not exist
     */
    public long length(){
        return file.length();
    }


    /**
     * Returns an array of strings naming the files and directories in the directory denoted by this abstract pathname.
     * If this abstract pathname does not denote a directory, then this method returns null. Otherwise an array of strings
     * is returned, one for each file or directory in the directory. Names denoting the directory itself and the directory's
     * parent directory are not included in the result. Each string is a file name rather than a complete path.
     * There is no guarantee that the name strings in the resulting array will appear in any specific order; they are not,
     * in particular, guaranteed to appear in alphabetical order.
     *
     * @return An array of strings naming the files and directories in the directory denoted by this abstract pathname.
     * The array will be empty if the directory is empty. Returns null if this abstract pathname does not denote a directory,
     * or if an I/O error occurs.
     */
    public iceTea.lang.String[] list(){
        String[] javaList = file.list();
        int index = javaList.length;
        iceTea.lang.String[] iceTeaList = new iceTea.lang.String[index];
        while(--index>=0){
            iceTeaList[index] = IceteaStringSupport.fromJavaLangString(javaList[index]);
        }
        return iceTeaList;
    }


    public File[] listFiles(){
        iceTea.lang.String[] list = list();
        int index = list.length;
        File[] listFiles = new File[index];
        while(--index>=0){
            listFiles[index] = new File(list[index]);
            list[index].dispose();
        }
        return listFiles;
    }


    public boolean mkdir(){
        return file.mkdir();
    }


    public boolean renameTo(File destination){
        return file.renameTo(destination.getFile());
    }


    public boolean setLastModified(long time){
        return file.setLastModified(time);
    }


    public boolean setReadOnly(){
        return file.setReadOnly();
    }


    @Override
	public String toString(){
        return file.toString();
    }

}
