package com.ist.allocator;

import iceTea.lang.support.I2JBestFitAllocatorMapping;
import iceTea.lang.Object;
import iceTea.lang.Memories;
import com.ist.allocator.BestFitAllocator;
import com.ist.allocator.AllocatorHooks;
import com.ist.allocator.AllocatorConstants;

public class BestFitAllocator extends Object implements AllocatorConstants{

	public static int NbAllocatedBytes;
	public static int OffsetAddressInTable;
	
	private BestFitAllocator() {
		super();
	}
	
	public static void initialize() {
		int r = Memories.ram();
		int startAddress = I2JBestFitAllocatorMapping.HeapStart;
		BestFitAllocator.OffsetAddressInTable = -12 + startAddress;
		Memories.intMemory[(startAddress >> 2)] = 16;
		int nullValue = 0;
		int addressOfAddressOfLastBlockInTable = 64 + startAddress;
		int addr = startAddress + 4;
		
		while (addr < addressOfAddressOfLastBlockInTable){
			Memories.intMemory[(addr >> 2)] = nullValue;
			addr += 4;
		}
		
		int addressOfLastBlock = addressOfAddressOfLastBlockInTable + 8;
		Memories.intMemory[(addressOfAddressOfLastBlockInTable >> 2)] = addressOfLastBlock;
		int addressOfLeftLimit = addressOfAddressOfLastBlockInTable + 4;
		Memories.intMemory[(addressOfLeftLimit >> 2)] = nullValue;
		Memories.intMemory[(addressOfLastBlock >> 2)] = nullValue;
	}
	public static int malloc(int size, int callerAddress) {
		int r = Memories.ram();
		int returnAddress;
		int flags = AllocatorHooks.enterCriticalSection();
		{
			int nullAddress = 0;
			int startAddress = I2JBestFitAllocatorMapping.HeapStart;
			int tableLength = Memories.intMemory[(startAddress >> 2)];
			int addressLinkedList = (startAddress + (tableLength << 2)) - 4;
			if((size & 3) != 0) 
				size = (size & -4) + 4;
			
			if(size < 8) 
				size = 8;
			
			size += 8;
			if(false) {
				size += 4;
			}
			
			if(false) {
				BestFitAllocator.NbAllocatedBytes += size;
			}
			
			int addressAllocatedBlock;
			int addressInTable;
			if(size < (8 + (tableLength << 2))) {
				addressInTable = size + BestFitAllocator.OffsetAddressInTable;
				addressAllocatedBlock = Memories.intMemory[(addressInTable >> 2)];
				if(addressAllocatedBlock == nullAddress) {
					addressInTable = 16 + addressInTable;
					
					while (addressInTable < addressLinkedList){
						addressAllocatedBlock = Memories.intMemory[(addressInTable >> 2)];
						if(addressAllocatedBlock != nullAddress) 
							break;
						
						addressInTable = addressInTable + 4;
					}
					
					if(addressAllocatedBlock != nullAddress) {
						int freeBlockSize = (Memories.intMemory)[((addressAllocatedBlock + 0)/*MemoryBlockHeader.sizeAndStatus*/ >> 2)] - size;
						int freeBlockAddress = addressAllocatedBlock + size;
						Memories.intMemory[((freeBlockAddress + 0)/*MemoryBlockHeader.sizeAndStatus*/ >> 2)] = freeBlockSize;
						Memories.intMemory[(((freeBlockAddress + freeBlockSize) - 4) >> 2)] = freeBlockSize;
						BestFitAllocator.insertFreeBlock(freeBlockAddress, freeBlockSize, tableLength, addressLinkedList);
					}
					
				}
				
			}
			else {
				addressAllocatedBlock = nullAddress;
				addressInTable = nullAddress;
			}
			
			if(addressAllocatedBlock != nullAddress) {
				int addressNextBlock = Memories.intMemory[((addressAllocatedBlock + 8)/*MemoryBlockHeader.addressNextBlock*/ >> 2)];
				Memories.intMemory[(addressInTable >> 2)] = addressNextBlock;
				if(addressNextBlock != nullAddress) 
					Memories.intMemory[((addressNextBlock + 4)/*MemoryBlockHeader.addressPreviousBlock*/ >> 2)] = nullAddress;
				
			}
			else {
				addressAllocatedBlock = Memories.intMemory[(addressLinkedList >> 2)];
				int sizeFound = 0;
				int blockHeader = 0;/*com.ist.allocator.MemoryBlockHeader blockHeader = null;*/
				
				while ((addressAllocatedBlock != nullAddress) && ((sizeFound = Memories.intMemory[(((blockHeader = addressAllocatedBlock) + 0)/*MemoryBlockHeader.sizeAndStatus*/ >> 2)]) < size)){
					addressAllocatedBlock = Memories.intMemory[((blockHeader + 8)/*MemoryBlockHeader.addressNextBlock*/ >> 2)];
				}
				
				if((addressAllocatedBlock != nullAddress) && (sizeFound > size)) {
					int sizeToFind = size + 16;
					
					while (sizeFound < sizeToFind){
						addressAllocatedBlock = Memories.intMemory[((blockHeader + 8)/*MemoryBlockHeader.addressNextBlock*/ >> 2)];
						if(addressAllocatedBlock == nullAddress) {
							break;
						}
						
						blockHeader = addressAllocatedBlock;
						sizeFound = Memories.intMemory[((blockHeader + 0)/*MemoryBlockHeader.sizeAndStatus*/ >> 2)];
					}
					
				}
				
				if(addressAllocatedBlock == nullAddress) {
					int addressOfAddressOfLastBlock = addressLinkedList + 4;
					int addressOfLastBlock = Memories.intMemory[(addressOfAddressOfLastBlock >> 2)];
					addressAllocatedBlock = addressOfLastBlock;
					addressOfLastBlock = addressAllocatedBlock + size;
					if(addressOfLastBlock >= I2JBestFitAllocatorMapping.HeapEnd) {
						AllocatorHooks.outOfMemory();
						/*assert false;*/
					}
					
					Memories.intMemory[(addressOfLastBlock >> 2)] = nullAddress;
					Memories.intMemory[(addressOfAddressOfLastBlock >> 2)] = addressOfLastBlock;
				}
				else {
					int addressPreviousBlock = Memories.intMemory[((blockHeader + 4)/*MemoryBlockHeader.addressPreviousBlock*/ >> 2)];
					int addressNextBlock = Memories.intMemory[((blockHeader + 8)/*MemoryBlockHeader.addressNextBlock*/ >> 2)];
					if(addressPreviousBlock == nullAddress) {
						Memories.intMemory[(addressLinkedList >> 2)] = addressNextBlock;
					}
					else {
						Memories.intMemory[((addressPreviousBlock + 8)/*MemoryBlockHeader.addressNextBlock*/ >> 2)] = addressNextBlock;
					}
					
					if(addressNextBlock != nullAddress) {
						Memories.intMemory[((addressNextBlock + 4)/*MemoryBlockHeader.addressPreviousBlock*/ >> 2)] = addressPreviousBlock;
					}
					
					if(sizeFound > size) {
						int freeBlockSize = sizeFound - size;
						int freeBlockAddress = addressAllocatedBlock + size;
						Memories.intMemory[((freeBlockAddress + 0)/*MemoryBlockHeader.sizeAndStatus*/ >> 2)] = freeBlockSize;
						Memories.intMemory[(((freeBlockAddress + freeBlockSize) - 4) >> 2)] = freeBlockSize;
						BestFitAllocator.insertFreeBlock(freeBlockAddress, freeBlockSize, tableLength, addressLinkedList);
					}
					
				}
				
			}
			
			int blockHeader = addressAllocatedBlock;/*com.ist.allocator.MemoryBlockHeader blockHeader = new com.ist.allocator.MemoryBlockHeader(addressAllocatedBlock);*/
			Memories.intMemory[((blockHeader + 0)/*MemoryBlockHeader.sizeAndStatus*/ >> 2)] = size | -2147483648;
			if(false) {
				addressAllocatedBlock += 4;
				size -= 4;
				Memories.intMemory[(addressAllocatedBlock >> 2)] = callerAddress;
			}
			
			Memories.intMemory[(((addressAllocatedBlock + size) - 4) >> 2)] = Memories.intMemory[((blockHeader + 0)/*MemoryBlockHeader.sizeAndStatus*/ >> 2)];
			returnAddress = addressAllocatedBlock + 4;
		}
		
		AllocatorHooks.exitCriticalSection(flags);
		return returnAddress;
	}
	private static void insertFreeBlock(int freeBlockAddress, int freeBlockSize, int tableLength, int addressLinkedList) {
		int nullAddress = 0;
		int r = Memories.ram();
		if(freeBlockSize < (8 + (tableLength << 2))) {
			int currentAddressInTable = freeBlockSize + BestFitAllocator.OffsetAddressInTable;
			int blockAddress = Memories.intMemory[(currentAddressInTable >> 2)];
			Memories.intMemory[(currentAddressInTable >> 2)] = freeBlockAddress;
			int blockHeader = freeBlockAddress;/*com.ist.allocator.MemoryBlockHeader blockHeader = new com.ist.allocator.MemoryBlockHeader(freeBlockAddress);*/
			Memories.intMemory[((blockHeader + 4)/*MemoryBlockHeader.addressPreviousBlock*/ >> 2)] = nullAddress;
			Memories.intMemory[((blockHeader + 8)/*MemoryBlockHeader.addressNextBlock*/ >> 2)] = blockAddress;
			if(blockAddress != nullAddress) 
				Memories.intMemory[((blockAddress + 4)/*MemoryBlockHeader.addressPreviousBlock*/ >> 2)] = freeBlockAddress;
			
		}
		else {
			int currentBlockAddress = Memories.intMemory[(addressLinkedList >> 2)];
			int previousBlockAddress = nullAddress;
			
			while (currentBlockAddress != nullAddress){
				int currentBlockHeader = currentBlockAddress;/*com.ist.allocator.MemoryBlockHeader currentBlockHeader = new com.ist.allocator.MemoryBlockHeader(currentBlockAddress);*/
				if((Memories.intMemory)[((currentBlockHeader + 0)/*MemoryBlockHeader.sizeAndStatus*/ >> 2)] >= freeBlockSize) 
					break;
				
				previousBlockAddress = currentBlockAddress;
				currentBlockAddress = Memories.intMemory[((currentBlockHeader + 8)/*MemoryBlockHeader.addressNextBlock*/ >> 2)];
			}
			
			if(previousBlockAddress == nullAddress) {
				Memories.intMemory[(addressLinkedList >> 2)] = freeBlockAddress;
			}
			else {
				Memories.intMemory[((previousBlockAddress + 8)/*MemoryBlockHeader.addressNextBlock*/ >> 2)] = freeBlockAddress;
			}
			
			int freeBlockHeader = freeBlockAddress;/*com.ist.allocator.MemoryBlockHeader freeBlockHeader = new com.ist.allocator.MemoryBlockHeader(freeBlockAddress);*/
			Memories.intMemory[((freeBlockHeader + 4)/*MemoryBlockHeader.addressPreviousBlock*/ >> 2)] = previousBlockAddress;
			Memories.intMemory[((freeBlockHeader + 8)/*MemoryBlockHeader.addressNextBlock*/ >> 2)] = currentBlockAddress;
			if(currentBlockAddress != nullAddress) 
				Memories.intMemory[((currentBlockAddress + 4)/*MemoryBlockHeader.addressPreviousBlock*/ >> 2)] = freeBlockAddress;
			
		}
		
	}
	private static void disconnectFreeBlock(int addr, int size, int addressLinkedList) {
		int r = Memories.ram();
		int startAddress = I2JBestFitAllocatorMapping.HeapStart;
		int tableLength = Memories.intMemory[(startAddress >> 2)];
		int freeBlockHeader = addr;/*com.ist.allocator.MemoryBlockHeader freeBlockHeader = new com.ist.allocator.MemoryBlockHeader(addr);*/
		int previousBlockAddress = Memories.intMemory[((freeBlockHeader + 4)/*MemoryBlockHeader.addressPreviousBlock*/ >> 2)];
		int nextBlockAddress = Memories.intMemory[((freeBlockHeader + 8)/*MemoryBlockHeader.addressNextBlock*/ >> 2)];
		if(previousBlockAddress == 0) {
			int addressInTable;
			if(size < (8 + (tableLength << 2))) 
				addressInTable = size + BestFitAllocator.OffsetAddressInTable;
			else 
				addressInTable = addressLinkedList;
			
			Memories.intMemory[(addressInTable >> 2)] = nextBlockAddress;
		}
		else 
			Memories.intMemory[((previousBlockAddress + 8)/*MemoryBlockHeader.addressNextBlock*/ >> 2)] = nextBlockAddress;
		
		if(nextBlockAddress != 0) 
			Memories.intMemory[((nextBlockAddress + 4)/*MemoryBlockHeader.addressPreviousBlock*/ >> 2)] = previousBlockAddress;
		
	}
	public static void free(int addr) {
		int r = Memories.ram();
		int flags = AllocatorHooks.enterCriticalSection();
		{
			addr = addr - 4;
			if(false) {
				addr -= 4;
			}
			
			int startAddress = I2JBestFitAllocatorMapping.HeapStart;
			int tableLength = Memories.intMemory[(startAddress >> 2)];
			int addressLinkedList = (-4 + startAddress) + (tableLength << 2);
			/*assert (new com.ist.allocator.MemoryBlockHeader(addr).sizeAndStatus&0x80000000)!=0;*/
			int size = (Memories.intMemory)[((addr + 0)/*MemoryBlockHeader.sizeAndStatus*/ >> 2)] & 2147483647;
			if(false) {
				BestFitAllocator.NbAllocatedBytes -= size;
			}
			
			int sizeAndStatusBlock = Memories.intMemory[((addr - 4) >> 2)];
			if(sizeAndStatusBlock > 0) {
				addr = addr - sizeAndStatusBlock;
				size = size + sizeAndStatusBlock;
				BestFitAllocator.disconnectFreeBlock(addr, sizeAndStatusBlock, addressLinkedList);
			}
			
			int nextBlockAddress = addr + size;
			sizeAndStatusBlock = Memories.intMemory[((nextBlockAddress + 0)/*MemoryBlockHeader.sizeAndStatus*/ >> 2)];
			if(sizeAndStatusBlock > 0) {
				size = size + sizeAndStatusBlock;
				BestFitAllocator.disconnectFreeBlock(nextBlockAddress, sizeAndStatusBlock, addressLinkedList);
			}
			else 
				if(sizeAndStatusBlock == 0) {
					int addressOfAddressOfLastBlock = addressLinkedList + 4;
					Memories.intMemory[(addr >> 2)] = 0;
					Memories.intMemory[(addressOfAddressOfLastBlock >> 2)] = addr;
					AllocatorHooks.exitCriticalSection(flags);
					return;
				}
				
			
			int blockHeader = addr;/*com.ist.allocator.MemoryBlockHeader blockHeader = new com.ist.allocator.MemoryBlockHeader(addr);*/
			Memories.intMemory[((blockHeader + 0)/*MemoryBlockHeader.sizeAndStatus*/ >> 2)] = size;
			Memories.intMemory[(((addr + size) - 4) >> 2)] = size;
			BestFitAllocator.insertFreeBlock(addr, size, tableLength, addressLinkedList);
		}
		
		AllocatorHooks.exitCriticalSection(flags);
	}
	public static void traceAllocatedMemory() {
		int r = Memories.ram();
		if(false) {
			int nbAllocatedBytes = BestFitAllocator.NbAllocatedBytes;
			AllocatorHooks.traceAllocatedMemory(nbAllocatedBytes);
			if(false) {
				int allocatedMemoryAddress = I2JBestFitAllocatorMapping.HeapStart;
				allocatedMemoryAddress += ((Memories.intMemory)[(allocatedMemoryAddress >> 2)] << 2) + 8;
				int size = Memories.intMemory[(allocatedMemoryAddress >> 2)];
				
				while (size != 0){
					if(size < 0) {
						size &= 2147483647;
						AllocatorHooks.traceAllocatedMemory((Memories.intMemory)[((allocatedMemoryAddress + 4) >> 2)] - 4, size);
					}
					
					allocatedMemoryAddress += size;
					size = Memories.intMemory[(allocatedMemoryAddress >> 2)];
				}
				
			}
			
		}
		
	}
	
}