/*
 * Java
 *
 * Copyright 2020-2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.drawing;

/**
 * LLDW_PAINTER_impl.h
 */
public class NativesTools {

	/*
	 * Native error constants
	 *
	 * WARNING copied in microui (class NSystemDisplay)
	 */

	/**
	 * no error
	 */
	public static final int NO_ERROR = 0;

	/**
	 * Native side cannot decode the file
	 */
	public static final int INVALID_TYPE = -1;

	/**
	 * oom
	 */
	public static final int OUT_OF_MEMORY = -2;

	/**
	 * File content is invalid
	 */
	public static final int INVALID_FILE = -3;

	/**
	 * File not found
	 */
	public static final int INVALID_PATH = -4;

	/**
	 * File has been closed
	 */
	public static final int FILE_CLOSED = -6;

	/**
	 * Anonymous error
	 */
	public static final int NOK = -9;

	private NativesTools() {
		// static class
	}

	/**
	 * Polygon (and deformImage) native algo requires some bytes to allocate its buffers:<br>
	 * = sizeOf(EdgeSP) * nbEdges * 2 + nbEdges*4 * 4 + sizeOf(PolygonSP)<br>
	 * = 40 * def * 2 + def * 4 * 4 + 20<br>
	 * = 96 * def + 20<br>
	 *
	 * @param nbEdges
	 *            number of edges to render
	 * @return the fill polygon (and deformImage) working buffer
	 */
	public static byte[] getPolygonWorkingBuffer(int nbEdges) {
		return new byte[96 * nbEdges + 20];
	}

}
