/*
 * Java
 *
 * Copyright 2010-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.sni;

public class SNI {

	/**
	 * @throws ArrayIndexOutOfBoundsException if the output byte array length is lower or equal to the string length (need at least <code>javaString.length()+1</code> bytes)
	 */
	public static void toCString(String javaString, byte[] cString) {
		// check if parameters null
		if (javaString == null || cString == null) {
			throw new IllegalArgumentException() ;
		}

		javaString.toCString(cString);
	}

	public static byte[] toCString(String javaString) {
		if (javaString == null) {
			throw new IllegalArgumentException() ;
		}
		byte[] cString = new byte[javaString.length() + 1];
		toCString(javaString, cString);
		return cString;
	}


	public static String toJavaString(byte[] cString) {
		// check if parameters null
		if (cString == null || cString.length == 0) {
			throw new IllegalArgumentException() ;
		}

		// get the string length
		int length = 0 ;
		try{
			while (cString[length] != 0){
				length++ ;
			}
		}
		catch (ArrayIndexOutOfBoundsException e) {
			// the C string is not NULL terminated
			throw new IllegalArgumentException() ;
		}

		// create the Java String using default encoding
		String javaString = new String(cString, 0, length) ;
		return javaString ;
	}

}
