/**
 * Java
 * 
 * Copyright 2014 IS2T. All rights reserved
 * IS2T PROPRIETARY/CONFIDENTIAL Use is subject to license terms.
 */
package ej.sni;


/**
 * Resources are allocated at creation time (no lazy allocation).
 */
public abstract class PoolOfLimitedReusableResources extends PoolOfReusableResources {

	protected int allocationSize;

	/**
	 * @param maxNbResources 0 (i.e. unlimited) is not allowed.
	 */
	public PoolOfLimitedReusableResources(int maxNbResources, int allocationSize) {
		super(maxNbResources);
		if(maxNbResources == 0)
			throw new IllegalArgumentException();
		this.allocationSize = allocationSize;

		// definitely allocate buffers
		Object[] resources = new Object[maxNbResources];
		for(int i=maxNbResources; --i>=0;){
			resources[i] = reserve();
		}
		for(int i=maxNbResources; --i>=0;){
			release(resources[i]);
		}		
	}

	public int getAllocationSize() {
		return allocationSize;
	}

	

}
