/**
 * Java
 * 
 * Copyright 2010-2016 IS2T. All rights reserved
 * IS2T PROPRIETARY/CONFIDENTIAL Use is subject to license terms.
 */
package ej.sni;

import ej.bon.Immortals;


/**
 * A pool of reusable immortal byte buffers.
 */
public class PoolOfImmortalByteBuffers extends PoolOfLimitedReusableResources{

	/**
	 * @param allocationSize size of allocated resources (in bytes). 0 (i.e. unlimited) is not allowed.
	 */
	public PoolOfImmortalByteBuffers(int maxNbResources, int allocationSize) {
		super(maxNbResources, allocationSize);
	}

	protected Object newResource() {
		return Immortals.setImmortal(new byte[allocationSize]);
	}

}
