/*
 * Java
 *
 * Copyright 2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.sni;

import java.lang.ref.WeakReference;

/**
 * {@link WeakReference} that will close automatically a {@link NativeResource} when the reference is set to null (i.e. the
 * referenced object is garbage collected).
 */
final public class AutoCloseWeakRef extends WeakReference<Object> {

	/**
	 * May be set to null by the VM.
	 */
	private NativeResource nativeResource; // VM Known

	/**
	 * Creates an {@link AutoCloseWeakRef} that will close the given {@link NativeResource} when <code>referent</code> will be garbage collected.
	 * @param referent the object to monitor for garbage collection
	 * @param nativeResource the native resource to close automatically
	 */
	public AutoCloseWeakRef(Object referent, NativeResource nativeResource) {
		super(referent);
		this.nativeResource = nativeResource;
	}

}
