/*
 * Java
 *
 * Copyright 2022-2025 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microvg.image;

import ej.microvg.VectorImage;

/**
 * Represents an element of a {@link VectorImage}: a path associated with a color or a gradient.
 */
public abstract class PathElement implements ImageElement {

	/* package */ final byte[] path;
	/* package */ final int fillRule;

	/**
	 * Cannot create the object at runtime: it is always an immutable object. However the constructor is required to
	 * prevent Java compiler errors.
	 */
	/* package */ PathElement(byte[] path, int fillRule) {
		this.path = path;
		this.fillRule = fillRule;
	}
}
