/*
 * Java
 *
 * Copyright 2022-2025 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microvg;

/**
 * Provides static native methods called by {@link LinearGradient}.
 */
/* package */ class GradientNatives {

	static {
		VectorGraphicsNatives.startup();
	}

	private GradientNatives() {
		// Prevent instantiation.
	}

	/**
	 * Initializes the gradient array.
	 * <p>
	 * If the implementation requires a bigger array, it must return the number of required bytes.
	 *
	 * @param sniContext
	 *            the array to initialize
	 * @param length
	 *            the array size
	 * @param colors
	 *            the colors to store
	 * @param count
	 *            the available number of colors and positions
	 * @param positions
	 *            the colors positions
	 * @param xStart
	 *            the x-coordinate for the start of the gradient vector
	 * @param yStart
	 *            the y-coordinate for the start of the gradient vector
	 * @param xEnd
	 *            the x-coordinate for the end of the gradient vector
	 * @param yEnd
	 *            the y-coordinate for the end of the gradient vector
	 * @return 0 on success or a value that indicates the minimal required size of the array.
	 */
	/* package */ static native int initializeGradient(int[] sniContext, int length, int[] colors, int count,
			float[] positions, float xStart, float yStart, float xEnd, float yEnd);

}
