/*
 * Java
 *
 * Copyright 2008-2013 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.util;

import com.is2t.vm.support.err.EDCErrorMessages;

import ej.error.Message;

public class Random implements java.io.Serializable {

	private long seed ;
	private double nextNextGaussian;
	private boolean haveNextNextGaussian = false;
	
    public Random() {
    	this(System.currentTimeMillis()) ;
    }

    public Random(long seed) {
    	this.seed = seed ;
    }

    protected synchronized int next(int bits) {
    	seed = (seed * 0x5DEECE66DL + 0xBL) & ((1L << 48) - 1);
    	return (int)(seed >>> (48 - bits));
    }
    
    public boolean nextBoolean() {
    	// As in Javadoc
		return next(1) != 0; 
	}
    
    public void nextBytes(byte[] bytes) {
    	// As in Javadoc
		for(int i = 0, len = bytes.length; i < len;) {
			for(int rnd = nextInt(), n = Math.min(len - i, Integer.SIZE / Byte.SIZE); n-- > 0; rnd >>= Byte.SIZE) {
				bytes[i++] = (byte) rnd;
			}
		}
	}

    public double nextDouble() {
    	return (((long)next(26) << 27) + next(27)) / (double)(1L << 53);
    }

    public float nextFloat() {
    	return next(24) / ((float)(1 << 24));
    }
    
    public synchronized double nextGaussian() {
    	// As in Javadoc
		if(haveNextNextGaussian) {
			haveNextNextGaussian = false;
			return nextNextGaussian;
		} 
		else {
			double v1, v2, s;
			do {
				v1 = 2 * nextDouble() - 1; // between -1 and 1
				v2 = 2 * nextDouble() - 1; // between -1 and 1
				s = v1 * v1 + v2 * v2;
			} 
			while (s >= 1 || s == 0);
			double multiplier = Math.sqrt(-2 * Math.log(s) / s);
			nextNextGaussian = v2 * multiplier;
			haveNextNextGaussian = true;
			return v1 * multiplier;
		}
	}

    public int nextInt() {
    	return next(32);
    }

    public int nextInt(int n) {
    	if(n <= 0) {
            throw new IllegalArgumentException(Message.at(new EDCErrorMessages(), EDCErrorMessages.ArgumentMustBePositive));
    	}

        if((n & -n) == n) {  // i.e., n is a power of 2
            return (int)((n * (long)next(31)) >> 31);
        }

        int bits, val;
        do {
            bits = next(31);
            val = bits % n;
        } while(bits - val + (n-1) < 0);
        return val;
    }

    public long nextLong() {
    	 return ((long)next(32) << 32) + next(32);
    }

    public synchronized void setSeed(long seed) {
    	this.seed = (seed ^ 0x5DEECE66DL) & ((1L << 48) - 1);
    }

}
