/*
 * Java
 *
 * Copyright 2013-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */ 
package java.util;

import ej.annotation.NonNullByDefault;
import ej.annotation.Nullable;

@NonNullByDefault(Iterable.DISABLE_NULL_ANALYSIS_COLLECTIONS)
public interface ListIterator<E> extends Iterator<E> {

	void add(E e);

	boolean hasNext();

	boolean hasPrevious();

	E next();

	int nextIndex();

	@Nullable
	E previous();

	int previousIndex();

	void remove();

	void set(E e);
}
