/*
 * Java
 *
 * Copyright 2013-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.util;

import ej.annotation.NonNullByDefault;
import ej.annotation.Nullable;

@NonNullByDefault(Iterable.DISABLE_NULL_ANALYSIS_COLLECTIONS)
public abstract class Dictionary<K, V> {

	public Dictionary() {
	}

	public abstract Enumeration<V> elements();

	@Nullable 
	public abstract V get(Object key);

	public abstract boolean isEmpty();

	public abstract Enumeration<K> keys();

	@Nullable 
	public abstract V put(K key, V value);

	@Nullable 
	public abstract V remove(Object key);

	public abstract int size();

}
