/*
 * Java
 *
 * Copyright 2013-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.util;

import ej.annotation.NonNullByDefault;
import ej.annotation.Nullable;

@NonNullByDefault(Iterable.DISABLE_NULL_ANALYSIS_COLLECTIONS)
public abstract class AbstractSet<E> extends AbstractCollection<E> implements Set<E> {

	protected AbstractSet() {
	}

	@Override
	public boolean equals(@Nullable Object o) {
		if(this == o) {
			return true;
		}

		if(!(o instanceof Set)) {
			return false;
		}

		Set<?> oAsSet = (Set<?>) o;

		if(this.size() != oAsSet.size()) {
			return false;
		}

		try {
			return this.containsAll(oAsSet);
		}
		catch(ClassCastException e) {
			// Set of another type of this
			return false;
		}

	}

	@Override
	public int hashCode() {
		int hashCode = 0;
		 for(E e : this) {
		 	hashCode += (e == null ? 0 : e.hashCode());
		 }
		 return hashCode;
	}

	@Override
	public boolean removeAll(Collection<?> c) {
		boolean hasBeenChanged = false;
		if(this.size() > c.size()) {
			Iterator<?> iteratorOnC = c.iterator();
			while(iteratorOnC.hasNext()) {
				hasBeenChanged = this.remove(iteratorOnC.next()) || hasBeenChanged;
			}
		}
		else {
			Iterator<E> iteratorOnThis = this.iterator();
			while(iteratorOnThis.hasNext()) {
				if(c.contains(iteratorOnThis.next())) {
					iteratorOnThis.remove();
					hasBeenChanged = true;
				}
			}
		}
		return hasBeenChanged;
	}

}
