/*
 * Java
 *
 * Copyright 2008-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.lang.ref;

import ej.annotation.Nullable;

// Sonar : Abstract Class Without Abstract Method : This abstract class does not have any abstract methods
// There is no abstract method in API
public abstract class Reference<T> { //NOSONAR

	@Nullable
	public T ref ;//known by the vm

	/** Pointer used by the GC to keep a linked list of WeakReferences. */
	@SuppressWarnings("unused")
	@Nullable
	private Reference<T> next;//known by the vm

	/** {@link ReferenceQueue} to which this {@link Reference} can be enqueued. Set to null after enqueue because a Reference can be enqueued only once. */
	@Nullable
	ReferenceQueue<T> queue;//known by the vm

	/** Pointer used by the reference queue to keep a linked of the enqueued references.*/
	@Nullable
	/*default*/ Reference<T> nextInQueue;//known by the vm

	boolean isInQueue;//known by the vm

	protected Reference() {
		this(null, null);
	}

	protected Reference(@Nullable T reference) {
		this(reference, null);
	}

	protected Reference(@Nullable T reference, @Nullable ReferenceQueue<T> queue) {
		this.ref = reference;
		this.queue = queue;
	}

	public void clear() {
    	this.ref = null ;
    }

	public boolean enqueue() {
		return ReferenceQueue.enqueue(this);
	}

	@Nullable 
    public T get() {
    	return this.ref ;
    }

    public boolean isEnqueued() {
		return this.isInQueue;
	}

}
