/*
 * Java
 *
 * Copyright 2008-2013 IS2T. All rights reserved
 * IS2T PROPRIETARY/CONFIDENTIAL Use is subject to license terms.
 */
package java.lang;

import com.is2t.vm.support.err.EDCErrorMessages;

import ej.error.Message;

public class StringIndexOutOfBoundsException extends IndexOutOfBoundsException {

    public StringIndexOutOfBoundsException() {
    	super();
    }

    public StringIndexOutOfBoundsException(String s) {
    	super(s);
    }

    public StringIndexOutOfBoundsException(int index) {
    	super(Message.at(	new EDCErrorMessages(), 
    							EDCErrorMessages.StringIndexOutOfRange,
    							new Object[]{Integer.valueOf(index)}));
    }

}
