/*
 * Java
 *
 * Copyright 2013-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.lang;

import ej.annotation.Nullable;

public final class StringBuilder extends AbstractStringBuilder {

	public StringBuilder() {
		super();
	}

	public StringBuilder(CharSequence seq) {
		super(16 + seq.length());
		_append(seq);
	}

	public StringBuilder(int capacity) {
		super(capacity);
	}

	public StringBuilder(String str) {
		super(16 + str.length());
		_append(str);
	}

	public StringBuilder append(boolean b) {
		_append(Boolean.toString(b));
		return this;
	}

	public StringBuilder append(char c) {
		ensureCapacity(this.length + 1);
		this.sharedCharArray[length++] = c;
		return this;
	}

	public StringBuilder append(char[] str) {
		_append(str, 0, str.length);
		return this;
	}

	public StringBuilder append(char[] str, int offset, int len) {
		_append(str, offset, len);
		return this;
	}

	public StringBuilder append(@Nullable CharSequence csq) {
		_append(csq);
		return this;
	}

	public StringBuilder append(@Nullable CharSequence s, int start, int end) {
		_append(s, start, end);
		return this;
	}

	public StringBuilder append(double d) {
		_append(Double.toString(d));
		return this;
	}

	public StringBuilder append(float f) {
		_append(Float.toString(f));
		return this;
	}

	public StringBuilder append(int i) {
		_append(Integer.toString(i));
		return this;
	}

	public StringBuilder append(long lng) {
		_append(Long.toString(lng));
		return this;
	}

	public StringBuilder append(@Nullable Object obj) {
		// To handle null value of obj
		_append(String.valueOf(obj));
		return this;
	}

	public StringBuilder append(@Nullable String str) {
		_append(str);
		return this;
	}

	public StringBuilder append(@Nullable StringBuffer sb) {
		_append(sb);
		return this;
	}


	public StringBuilder delete(int start, int end) {
		_delete(start, end);
		return this;
	}

	public StringBuilder deleteCharAt(int index) {
		_deleteCharAt(index);
		return this;
	}
	
	public int indexOf(String str) {
		return indexOf(str, 0);
	}

	public StringBuilder insert(int offset, boolean b) {
		String value = Boolean.toString(b);
		_insert(offset, value.chars, value.offset, value.length);
		return this;
	}

	public StringBuilder insert(int offset, char c) {
		String value = String.valueOf(c);
		_insert(offset, value.chars, value.offset, value.length);
		return this;
	}

	public StringBuilder insert(int offset, char[] str) {
		_insert(offset, str, 0, str.length);
		return this;
	}

	public StringBuilder insert(int index, char[] str, int offset, int len) {
		_insert(index, str, offset, len);
		return this;
	}

	public StringBuilder insert(int dstOffset, @Nullable CharSequence s) {
		_insert(dstOffset, s);
		return this;
	}

	public StringBuilder insert(int dstOffset, @Nullable CharSequence s, int start, int end) {
		_insert(dstOffset, s, start, end);
		return this;
	}

	public StringBuilder insert(int offset, double d) {
		String value = Double.toString(d);
		_insert(offset, value.chars, value.offset, value.length);
		return this;
	}

	public StringBuilder insert(int offset, float f) {
		String value = Float.toString(f);
		_insert(offset, value.chars, value.offset, value.length);
		return this;
	}

	public StringBuilder insert(int offset, int i) {
		String value = Integer.toString(i);
		_insert(offset, value.chars, value.offset, value.length);
		return this;
	}

	public StringBuilder insert(int offset, long l) {
		String value = Long.toString(l);
		_insert(offset, value.chars, value.offset, value.length);
		return this;
	}

	public StringBuilder insert(int offset, Object obj) {
		String value = String.valueOf(obj);
		_insert(offset, value.chars, value.offset, value.length);
		return this;
	}

	public StringBuilder insert(int offset, @Nullable String str) {
		_insert(offset, str);
		return this;
	}

	public StringBuilder replace(int start, int end, String str) {
		_replace(start, end, str);
		return this;
	}

	public StringBuilder reverse() {
		_reverse();
		return this;
	}

}
