/*
 * Java
 *
 * Copyright 2008-2019 IS2T. All rights reserved
 * IS2T PROPRIETARY/CONFIDENTIAL Use is subject to license terms.
 */
package java.lang;

import com.is2t.vm.support.err.EDCErrorMessages;

import ej.error.Message;

public class StackOverflowError extends VirtualMachineError {

	public StackOverflowError() {
		super();
	}

	public StackOverflowError(String s) {
		super(s);
	}
	
	@Override
	public java.lang.String getMessage() {
		String message = super.getMessage();
		assert message != null; // message is an error code provided by the VM
		try{
			int errorCode = Integer.parseInt(message);
			return Message.at(new EDCErrorMessages(), errorCode);
		}
		catch(NumberFormatException nfe){
			//the message is not a valid error code, just return it.
			return message;
		}
	}
}
