/*
 * Java
 * 
 * Copyright 2008-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.lang;

import ej.annotation.Nullable;

public final class Short extends Number implements Comparable<Short> {

	public static final short MAX_VALUE = 32767;

	public static final short MIN_VALUE = -32768;

	public static final int SIZE = 16;
	
	/**
	 * @accelerable
	 */
	public static int compare(short x, short y) {
		if(x == y) {
			return 0;
		}
		else if(x < y) {
			return -1;
		}
		else {
			return 1;
		}
	}
	
	public static Short decode(String nm) throws NumberFormatException {
		// Steps: 
		// - decode as an integer
		// - check bounds
		
		// step 1
		int decode = Integer.decode(nm).intValue();
		
		// step 2
		if(decode > MAX_VALUE || decode < MIN_VALUE) {
			throw new NumberFormatException();
		}
		
		return valueOf((short) decode); // cast is safe
	}

	public static short parseShort(String s) throws NumberFormatException {
		return (short) Integer.parseInt(s, 10);
	}

	public static short parseShort(String s, int radix) throws NumberFormatException {
		// Steps: 
		// - parse as an integer
		// - check bounds
		
		// step 1
		int parse = Integer.parseInt(s, radix) ;
		
		// step 2
		if(parse > MAX_VALUE || parse < MIN_VALUE) {
			throw new NumberFormatException();
		}
		
		return (short) parse; // cast is safe
	}
	
//	public static short reverseBytes(short i) {
//	}
	
	public static String toString(short s) {
		// Delegate to Integer
		return Integer.toString(s, 10);
	}
	
	/*
	 * Not in CLDC API, implemented to manage autoboxing. Returns a Short instance representing the
	 * specified short value.
	 */
	public static Short valueOf(short value) {
		return new Short(value);
	}
	
	public static Short valueOf(String s) throws NumberFormatException {
		return new Short(Short.parseShort(s, 10));
	}
	
	public static Short valueOf(String s, int radix) throws NumberFormatException {
		return new Short(Short.parseShort(s, radix));
	}

	/* INSTANCE VARIABLES */
	private short value;

	public Short(short value) {
		this.value = value;
	}
	
	public Short(String s) throws NumberFormatException {
		this(parseShort(s));
	}
	
	public byte byteValue() {
		return (byte) this.value;
	}

	public int compareTo(Short o) {
		return compare(this.value, o.value);
	}

	public double doubleValue() {
		return (double) this.value;
	}

	public boolean equals(@Nullable Object obj) {
		try {
			return ((Short) obj).value == this.value;
		} catch (ClassCastException e) {
			return false;
		} catch (NullPointerException e) {
			return false;
		}
	}

	public float floatValue() {
		return (float) this.value;
	}

	public int hashCode() {
		return this.value;
	}

	public int intValue() {
		return (int) this.value;
	}

	public long longValue() {
		return (long) this.value;
	}

	public short shortValue() {
		return this.value;
	}

	public String toString() {
		return Integer.toString(this.value, 10);
	}
}
