/*
 * Java
 *
 * Copyright 2013-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.lang;

import ej.annotation.Nullable;

public class Package implements java.lang.reflect.AnnotatedElement {
	
	String name;

	private Package(String name){
		this.name = name;
	}

	public String getName() {
		return this.name;
	}

	@Override
	public int hashCode() {
		// See javadoc
		// hashCode is computed from the package name
		return this.name.hashCode();
	}

	@Override
	public String toString() {
		return "package "+ this.name; //$NON-NLS-1$
	}
	
	@Override
	public boolean equals(@Nullable Object obj) {
		if(obj == this){
			return true;
		}
				
		if(!(obj instanceof Package)){
			return false;
		}
		
		Package other = (Package) obj;
		return this.name.equals(other.name);
	}
	
	/**
	 * @see Class#getPackage()
	 */
	@Nullable
	/*default*/ static Package getPackage(Class<?> clazz){
		String classname = clazz.getName();
		int lastDot = classname.lastIndexOf('.');
		
		if(lastDot == -1 || classname.charAt(0)=='['){
			//default package or the class is an array
			return null;
		}
		else {
			return new Package(classname.substring(0, lastDot));
		}
	}
}
