/*
 * Java
 *
 * Copyright 2013-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */ 
package java.lang;

import java.util.Iterator;

import ej.annotation.NonNullByDefault;

@NonNullByDefault(false)
public interface Iterable<T> {

	/**
	 * This internal marker is used to disable null analysis detection within thhe Collections Framework.
	 * (The Collections Framework specification allow to use the <code>null</null> element, 
	 * but the API does not null elements when Null Analysis is enabled
	 * By disabling, the legacy code still manages cases where the collection element is null without changing the APIs Null annotations.  
	 */
	public static final boolean DISABLE_NULL_ANALYSIS_COLLECTIONS = false;
	
	Iterator<T> iterator();
}
