/*
 * Java
 *
 * Copyright 2013-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.lang;

import java.lang.CloneNotSupportedException;
import java.lang.Object;
import java.io.Serializable;

import ej.annotation.Nullable;

public abstract class Enum<E extends Enum<E>> implements Comparable<E>, Serializable {

	int ordinal;
	String name;
	
	public static <T extends Enum<T>> T valueOf(Class<T> enumType, String name) {
		//TODO WI 8364
		throw new NoSuchMethodError();
	}
	
	protected Enum(String name, int ordinal) {
		this.ordinal = ordinal;
		this.name = name;
	}

	protected final Object clone() throws CloneNotSupportedException {
		// Enum cannot be cloned
		throw new CloneNotSupportedException();
	}

	public final int compareTo(E o) {
		Enum<E> oAsEnum = o; // will throw ClassCastException if cast cannot be done
							 // as mentionned in compareTo Javadoc
		
		// Enum constants are only comparable to other enum constants 
		// of the same enum type
		// Use Enum.getDeclaringClass to check it (see getDeclaringClass javadoc:
		// Two enum constants e1 and e2 are of the same enum type if and only if 
		// e1.getDeclaringClass() == e2.getDeclaringClass()
		if(this.getClass() != oAsEnum.getClass()) { // TODO WI 8623 warning: does not handle inner class in enum!
			throw new ClassCastException(); // compareTo Javadoc
		}
		
		return this.ordinal - o.ordinal;
	}

	public final boolean equals(@Nullable Object other) {
		// Enums are singletons (see Enum javadoc). So compare object ref.
		return (this == other);
	}

//	public final Class<E> getDeclaringClass() {
////		getClass() versus getDeclaringClass()
////		
////		Consider the following example:
////		
////		public enum MyEnum {
////			A {
////				void foo() { }
////			}
////		};
////		
////		There will be an inner class for A body. This class will be a
////		subclass of MyEnum.
////		
////		MyEnum.A.getClass() will return the anonymous class representing A
////		MyEnum.A.getDeclaringClass() will return the class representing MyEnum
//		
//		Class thisClass = this.getClass();
//		Class superClass = thisClass.getSuperclass();
//		// Class objects are singletons
//		if(superClass == Enum.class) { // XXX this is impl. dependent!!!
//			// Superclass is Enum, so thisClass is the class representing
//			// the current Enum
//			return thisClass;
//		}
//		else {
//			// Superclass is not Enum, so thisClass is an anonymous class, 
//			// subclass of this current. superClass is the current enum class
//			return superClass;
//		}
//	}

	public final int hashCode() {
		// Nothing specified in Javadoc. Just return Object.hashCode...
		return super.hashCode();
	}

	public final String name() {
		return name;
	}

	public final int ordinal() {
		return this.ordinal;
	}

	public String toString() {
		return this.name;
	}

}
