package java.lang;

/*
  Some multi dim arrays are allocated just like if they were "plain" array, i.e.
  C arrays, that is they are not array of array of array of....
  In java, the behavior is to mark all subarray as deadSubarray in order
  to let the vm check if such object are used as regular object (aka receiving
  messages, used within monitor,....) which will then throw an exception.
  
  Example of usage : 
   
  int z;
  int[][] twoDimArray = (int[][])plain(new int[10][20]);
  z = twoDimArray[2][4]; //illegal access;
  z = twoDimArray.load_int(2,4); //legal access;
  twoDimArray[2][4] = z; //illegal store;
  twoDimArray.store_int(2,4,z); //legal store;
  
  
    
 */ 

public class DeadSubarrayException extends RuntimeException {
	public DeadSubarrayException() {
		super();
	}
	public DeadSubarrayException(String s) {
		super(s);
	}
}
