/*
 * Java
 * 
 * Copyright 2008-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.lang;

import ej.annotation.Nullable;

public final class Boolean implements java.io.Serializable, Comparable<Boolean> {
	
	/* CLASS CONSTANTS */
	// Boolean Instantiation : Avoid instantiating Boolean objects; reference Boolean.TRUE or Boolean.FALSE or call Boolean.valueOf() instead.
	public static final Boolean TRUE = new Boolean(true); //NOSONAR
	public static final Boolean FALSE = new Boolean(false); //NOSONAR
	
	private static final String TRUE_STRING = "true"; //$NON-NLS-1$
	private static final String FALSE_STRING = "false"; //$NON-NLS-1$
	
	/* INSTANCE VARIABLES */
	private boolean value ;
	
	public static int compare(boolean x, boolean y) {
		if(x == y) {
			return 0;
		}
		else if(x) {
			return 1;
		}
		else {
			return -1;
		}
	}
	
	public static boolean getBoolean(String name) {
		try {
			String value = System.getProperty(name);
			// System.getProperty may return "null" if the property does not exists
			// must check null value!
			return parseBoolean(value);
		} 
		catch (IllegalArgumentException /* key is empty */ | NullPointerException /* key is  null */ e) {
			return false;
		}
	}
	
	public static boolean parseBoolean(@Nullable String s) {
		return s != null && s.equalsIgnoreCase(TRUE_STRING);
	}
	
	public static String toString(boolean b) {
		return (b ? TRUE_STRING : FALSE_STRING);
	}
	
	public static Boolean valueOf(boolean b) {
		return (b ? TRUE : FALSE);
	}
	
	public static Boolean valueOf(@Nullable String s) {
		return valueOf(parseBoolean(s));
	}
		
	public Boolean(boolean value) {
		this.value = value ;
	}
	
	public Boolean(@Nullable String s) {
		this(parseBoolean(s));
	}

	public boolean booleanValue() {
		return value ;
	}
	
	public int compareTo(Boolean b) {
		// Same behavior
		return compare(this.value, b.value);
	}

	public boolean equals(@Nullable Object obj) {
		try {
			return ((Boolean)obj).value == this.value ;
		}
		catch (ClassCastException | NullPointerException e){
			// obj is not a Boolean | obj is null
			return false ;
		}
	}

	public int hashCode() {
		// If true  : 1231 (0x4CF)
		// If false : 1237 (0x4D5)
		return (this.value ? 0x4CF : 0x4D5) ;
	}
	
	public String toString() {
		return toString(this.value);
	}
}
