/*
 * Java
 *
 * Copyright 2008-2019 IS2T. All rights reserved
 * IS2T PROPRIETARY/CONFIDENTIAL Use is subject to license terms.
 */
package java.io;

import com.is2t.vm.support.err.EDCErrorMessages;

import ej.annotation.Nullable;
import ej.error.Message;

public abstract class Writer implements Appendable, Closeable, Flushable {

    protected Object lock ;
    
    protected Writer() {
    	this.lock = this ;
    }

    @SuppressWarnings({ "null", "unused" })// (EDC testsuite contains some tests with a null argument) 
	protected Writer(Object lock) {
    	if(lock == null) {
    		throw new NullPointerException(Message.at(new EDCErrorMessages(), EDCErrorMessages.StreamCantSyncOnNull)); //NOSONAR
    	}
    	this.lock = lock ;
    }
    
    public Writer append(char c) throws IOException {
    	this.write(c);
    	return this;
	}
    
    public Writer append(@Nullable CharSequence csq) throws IOException {
    	if(csq == null) {
    		this.write("null"); // see Javadoc //$NON-NLS-1$
		} 
    	else {
			this.write(csq.toString());
		}
		return this;
	}
    
    public Writer append(@Nullable CharSequence csq, int start, int end) throws IOException {
    	// Same as PrintStream.append(CharSequence, int, int)
    	CharSequence cs = (csq == null ? "null" : csq); //$NON-NLS-1$
    	CharSequence subSequence = cs.subSequence(start, end);
		this.write(subSequence.toString());
		return this;
	}

    public abstract void close() throws IOException;

    public abstract void flush() throws IOException;

    public void write(char[] cbuf) throws IOException {
    	this.write(cbuf, 0, cbuf.length);
    }

    // Subclasses should use 'lock' field to synchronize the writing of the argument 'cbuf'.
    public abstract void write(char[] cbuf,  int off, int len) throws IOException;

    public void write(int c) throws IOException {
    	this.write(new char[]{(char)c});
    }

    public void write(String str) throws IOException {
    	this.write(str.toCharArray(), 0, str.length());
    }

    public void write(String str, int off, int len) throws IOException {
    	this.write(str.chars, str.offset+off, len);
    }

}
