/*
 * Java
 *
 * Copyright 2008-2013 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.io;

import com.is2t.tools.ArrayTools;

public abstract class InputStream implements Closeable {

	/* IS2T CONSTANTS */
	private static final int SKIP_BUFFER_LENGTH = 1024 ;
	
    public int available() throws IOException {
    	// The available method for class InputStream always returns 0.
    	return 0 ;
    }

    public void close() throws IOException {
    	// The close method of InputStream does nothing.
    }

    public synchronized void mark(int readlimit) {
    	// The mark method of InputStream does nothing.
    }

    public boolean markSupported() {
    	// The markSupported method of InputStream returns false.
    	return false ;
    }

    public abstract int read() throws IOException ;

    public int read(byte[] b) throws IOException {
    	return this.read(b, 0, b.length) ;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        ArrayTools.checkBounds(b, off, len);
    	
    	int i = off-1 ;
    	int end = off + len;
    	
		try {
			while (++i < end) {
				int byteRead;
				b[i] = (byte)(byteRead = read());
				if(byteRead == -1) { // EOF
					return (i == off ? -1 : i - off) ;
				}
			}
		}
		catch (IOException e) {
			if(i == off) { // first call to read() resulted in an IOException
				throw e ;
			}
		}
		
		return i - off ;
    }

    public synchronized void reset() throws IOException {
    	// The method reset for class InputStream does nothing except
    	// throw an IOException.
    	throw new IOException();
    }

    public long skip(long n) throws IOException {
    	if(n <= 0) {
    		return 0 ;
    	}
    	
    	long oldn = n ;
    	int lengthToRead = n > SKIP_BUFFER_LENGTH ? SKIP_BUFFER_LENGTH : (int) n ;
    	byte[] buf = new byte[lengthToRead] ;
 
    	while(n > 0) {
    		int lengthRead = read(buf, 0, lengthToRead) ;
    		
    		if (lengthRead != -1) { // if !EOF
    			n -= lengthRead ;
     			if(n <  lengthToRead) {
    				lengthToRead = (int)n;
     			}
    		}
    		else {
    			break ;
    		}
    	}
    
    	return oldn -n ;
    }



}
