/*
 * Java
 *
 * Copyright 2013-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.io;

import ej.annotation.Nullable;

public class FilterOutputStream extends OutputStream {
	@Nullable 
	protected OutputStream out;
	
	public FilterOutputStream(@Nullable OutputStream out) {
		this.out = out;
		// When passing a null OutputStream, subclass must override 
		// all default OutputStream methods implementation
	}

	public void close() throws IOException {
		OutputStream out = this.out;
		if(out != null) {
			this.flush();
			out.close();
		}
	}

	public void flush() throws IOException {
		OutputStream out = this.out;
		assert out != null;
		out.flush();
	}

	public void write(byte[] b) throws IOException {
		this.write(b, 0, b.length);
	}

	public void write(byte[] b, int off, int len) throws IOException {
		// Javadoc:
		// Note that this method does not call the write method of its 
		// underlying input stream with the same arguments. Subclasses of 
		// FilterOutputStream should provide a more efficient implementation of 
		//this method.
		for(int i = 0; i < len; i++) {
			this.write(b[off + i]);
		}
	}

	public void write(int b) throws IOException {
		OutputStream out = this.out;
		assert out != null;
		out.write(b);
	}
}
