/*
 * Java
 *
 * Copyright 2008-2014 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.io;

public interface DataOutput {

    void write(byte[] b) throws IOException;

    void write(byte[] b, int off, int len) throws IOException;

    void write(int b) throws IOException;

    void writeBoolean(boolean v) throws IOException;

    void writeByte(int v) throws IOException;

    void writeChar(int v) throws IOException;

    void writeChars(String s) throws IOException;

    void writeDouble(double v) throws IOException;

    void writeFloat(float v) throws IOException;

    void writeInt(int v) throws IOException;

    void writeLong(long v) throws IOException;

    void writeShort(int v) throws IOException;

    void writeUTF(String s) throws IOException;

}
