/*
 * Java
 *
 * Copyright 2008-2013 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.io;

import com.is2t.tools.ArrayTools;
 
/* 
 * Implementation note:
 * See comment in ByteArrayOutputStream (same behavior)
 */
public class ByteArrayInputStream extends InputStream {
    
    protected byte[] buf;	//VM known
    protected int count;
    protected int mark;
    protected int pos;

    // Sonar:  Array is stored directly : The user-supplied array 'buf' is stored directly.
    // In 1.7 spec: The buffer array is not copied.
    public ByteArrayInputStream(byte[] buf) { //NOSONAR
    	this.buf = buf ;
    	this.count = buf.length ;
    	//this.mark=this.pos=0  -> VM done;
    }

    // Sonar:  Array is stored directly : The user-supplied array 'buf' is stored directly.
    // In 1.7 spec: The buffer array is not copied.
	public ByteArrayInputStream(byte[] buf, int offset, int length) { //NOSONAR
		//  Don't  test the validity of offset and length,  is not specify in cldc 1.1"
		this.buf = buf;
		this.pos = offset;
		this.count = Math.min(offset + length, buf.length);
	  	//this.mark =0  -> VM done;
	}
	
    public int available() {
    	return this.count - this.pos ;
    }

    public void close() throws IOException {
    	// do nothing (see class comment)
    }

    public void mark(int readAheadLimit) {
    	this.mark = this.pos ;
    }

    public boolean markSupported() {
    	return true ;
    }

    public synchronized int read() {
       	if ( this.pos==this.count  || pos <0) {
    		return -1 ;
       	}

       	return this.buf[this.pos++] & 0xff;
    }

    public synchronized int read(byte[] b, int off, int len) {
        ArrayTools.checkBounds(b, off, len);
                
    	int k = this.count - this.pos;
    	if(k <= 0) { //  bytes available
    		return -1 ;
    	}
    	
    	k = Math.min(k, len);

    	System.arraycopy(this.buf, this.pos, b, off, k);
    	this.pos += k ;
    	return k ;
    }

    public synchronized void reset() {
    	this.pos = this.mark ;
    }

    public synchronized long skip(long n) {
    	if(n > 0) {
    		long k = Math.min(this.count - this.pos, n) ;
    		this.pos += k ;
    		return k ;
    	}
    	return 0 ;
    }

}
