/*
 * Java
 *
 * Copyright 2010-2013 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.error;

public class Message {
	
	private Message() {
	}

	/**
	 * Returns a string representation of the message
	 * identified by the given index in the messages pool.
	 * @param messages the pool of messages
	 * @param index the index of the message to print
	 * @return a string representation of the message
	 */
	public static String at(ErrorMessages messages, int index) {
		// On S3, print the full String representation of the error
		return messages.category()+": "+messages.messageAt(index);
	}
	
	/**
	 * Returns a string representation of the message
	 * identified by the given index in the messages pool.
	 * @param messages the pool of messages
	 * @param index the index of the message to print
	 * @param values data associated with the message
	 * @return a string representation of the message
	 */
	public static String at(ErrorMessages messages, int index, Object[] values) {
		// TODO implement argument insertion support in ErrorMessages, as in compiler (\\0)
		StringBuffer stream = new StringBuffer(at(messages,index));
		if (values != null){
			int length = values.length;
			for (int i=-1; ++i<length;){
				stream.append(' ');
				stream.append(values[i]);
			}
		}
		return stream.toString();
	}
	
	/**
	 * Returns a string representation of the message
	 * identified by the given index in the messages pool.
	 * @param messages the pool of messages
	 * @param index the index of the message to print
	 * @param value data associated with the message
	 * @return a string representation of the message
	 */
	public static String at(ErrorMessages messages, int index, Object value) {
		return at(messages, index)+" ("+value+")";
	}
	
}
