/*
 * Java
 *
 * Copyright 2011-2013 IS2T. All rights reserved
 * IS2T PROPRIETARY/CONFIDENTIAL Use is subject to license terms.
 */
package com.is2t.vm.support.io;

import java.io.IOException;
import java.io.OutputStream;

import com.is2t.tools.ArrayTools;

/**
 * 
 */
public class MemoryOutputStream extends OutputStream{

    int endAddress;		//exclusive
    int currentPtr;
	
	/**
	 *  Create a new MemoryOutputStream whose mapped the memories
	 *  addresses : [startAdress,  startAdress+ length]
	 * 
	 * @param startAddress start address of the stream in the memory
	 * @param length data length
	 */
	public MemoryOutputStream(int startAddress, int length)
	{
		this.currentPtr = startAddress;
		this.endAddress = startAddress+length;
	}

	public void write(byte[] b) throws IOException {
    	write(b, 0, b.length) ;
    }
	
	public void write(int b) throws IOException {
		if(currentPtr >= endAddress) {
			throw new IOException();
		}
		
		writeNative(currentPtr, b);
		currentPtr++;
	}
	
    public void write(byte[] b, int offset, int len) throws IOException {
    	ArrayTools.checkBounds(b, offset, len);
    	
    	if(currentPtr+len > endAddress) {
    		throw new IOException();
    	}
    	
    	currentPtr = writeArrayNative(currentPtr, b, offset, len);
    }

	public static native void writeNative(int addr, int b) throws IOException;
	public static native int writeArrayNative(int addr, byte[] b, int offset, int len) throws IOException;

}
